/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.flir;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class FlirIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.flir.FlirIOHandler";
    private int errorCode;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        DigitalInputSrv[] iServices;
                        previousLoopWithError = false;
                        DigitalInputSrv[] digitalInputSrvArray = iServices = super.getDigitalInputSrv();
                        int n = digitalInputSrvArray.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = digitalInputSrvArray[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this, ex);
                    } else if (ex.getMessage().contains("Address already in use")) {
                        this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this, ex);
                    } else {
                        this.logger.warn("Unknown trouble for " + this, ex);
                    }
                    try {
                        DigitalInputSrv[] iServices;
                        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public DigitalInputSrv[] getDigitalInputSrv() {
        return super.getDigitalInputSrv();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        StringBuilder sbURL = new StringBuilder(512);
        sbURL.append("/params/get.cgi?Cc-1.Input-*.CcDetectAlarm");
        String digitalInput = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sbURL.toString(), (int)Integer.MAX_VALUE));
        for (DigitalInputSrv iService : iServices) {
            String[] alarmData;
            int inputNumber = iService.getInputNumber();
            for (String alarmData1 : alarmData = digitalInput.split("\r\n")) {
                String[] alarmLine;
                if (!alarmData1.toLowerCase().contains("input-" + inputNumber) || (alarmLine = alarmData1.split("CcDetectAlarm=")).length != 2) continue;
                if (alarmLine[1].toLowerCase().contains("on")) {
                    iService.checkInput(1);
                    continue;
                }
                iService.checkInput(0);
            }
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] :-(");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
            return -21601;
        }
        try {
            IOHandler.HoldTimer holdTimer;
            if (holdTime > 0L && (this.errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + this.errorCode + "] :-(");
            }
            StringBuilder url = new StringBuilder(256);
            url.append("/params/set.cgi?Cc-1.Output-").append(outputNumber).append(".OperationalMode=");
            if (value == 1) {
                url.append("Force%20active");
            } else {
                url.append("Force%20inactive");
            }
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Could not send Data to digital Output ");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot write value [" + value + "] to output [" + outputNumber + "] :-(" + ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot write value [" + value + "] to output [" + outputNumber + "] :-(");
        }
        return 0;
    }
}

