/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.flir;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.flir.FlirIOHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class FlirDevice
extends VideoServer {
    private String firmwareVersion = null;
    private byte[] result = null;
    private int errorCode;
    private NetworkParameter networkParameter;
    private boolean globalParametersSet = false;
    private boolean credentialsTested = false;
    private static final int PAL = 1;
    private static final int NTSC = 2;
    private boolean videoSystemSet = false;

    @Override
    protected IOHandler createIOHandler() {
        return new FlirIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    public String getFirmwareVersion() {
        if (this.firmwareVersion == null) {
            this.firmwareVersion = this.determineFirmwareVersion();
        }
        return this.firmwareVersion;
    }

    private String determineFirmwareVersion() {
        try {
            String url = "/params/get.cgi?General.ProductVersion";
            this.result = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE);
            if (this.result == null) {
                this.logger.error("Could not read firmware version from " + this);
            } else {
                String[] firmwareLines = new String(this.result).split("=");
                if (firmwareLines.length == 2) {
                    return firmwareLines[1];
                }
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration exception while reading firmware version of " + this + ": " + ex.getMessage());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading firmware version of " + this + ": " + ex.getMessage());
        }
        return "<unknown>";
    }

    public String getResolutionTag(int width, int height, int videoSystem) {
        String resolution = null;
        if (videoSystem == 1) {
            if (width == 1920 && height == 1080) {
                resolution = "HD1080";
            } else if (width == 1280 && height == 720) {
                resolution = "HD720";
            } else if (width == 960) {
                resolution = "960H";
            } else if (width == 720) {
                resolution = height == 288 ? "2CIF" : "D1";
            } else if (width == 704) {
                resolution = height == 288 ? "2CIF" : "D1";
            } else if (width == 640) {
                resolution = "VGA";
            } else if (width == 352 && height == 288) {
                resolution = "CIF";
            }
        } else if (width == 1920 && height == 1080) {
            resolution = "HD1080";
        } else if (width == 1280 && height == 720) {
            resolution = "HD720";
        } else if (width == 960) {
            resolution = "960H";
        } else if (width == 720) {
            resolution = height == 240 ? "2CIF" : "D1";
        } else if (width == 640) {
            resolution = "VGA";
        } else if (width == 352 && height == 240) {
            resolution = "CIF";
        }
        return resolution;
    }

    public int setVideoSystem(String videoSystem) throws SeeTecException, ConfigurationException {
        if (this.videoSystemSet) {
            return 0;
        }
        this.videoSystemSet = true;
        this.result = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/params/set.cgi?Video-1.Input-1.VideoStandard=" + videoSystem), (int)Integer.MAX_VALUE);
        if (this.result == null) {
            throw new SeeTecException(-20100, "Could not connect to encoder");
        }
        String resultString = new String(this.result);
        if (resultString.toLowerCase().indexOf("unauthorized") != -1) {
            throw new SeeTecException(-21657, "Authentication failed");
        }
        String[] videoStandards = resultString.split("=");
        if (videoStandards.length > 0 && videoStandards[1].toLowerCase().indexOf("ntsc") != -1) {
            this.logger.info("VideoSystem was set to NTSC");
        } else {
            this.logger.info("VideoSystem was set to PAL");
        }
        return 0;
    }

    public float getMaximalFramerate(int videoSystem, Codec codec, int encoderNumber, int videoSource) {
        if (videoSystem == 2) {
            return 30.0f;
        }
        return 25.0f;
    }

    public int testCredentials(NetworkParameter networkParameter) throws SeeTecException {
        if (!this.credentialsTested) {
            String testUrl = "/frame.html";
            this.result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)testUrl, (int)Integer.MAX_VALUE);
            if (this.result == null) {
                this.logger.error("Error connecting to camera for " + this);
                return -20100;
            }
            if (new String(this.result).toLowerCase().contains("unauthorized")) {
                this.logger.error("Wrong Authentication data for " + this);
                return -21657;
            }
        }
        this.credentialsTested = true;
        return 0;
    }

    public int setGlobalParameters(int videoSourceNumber, boolean useDateTime, boolean useTitle, String title) throws ConfigurationException, SeeTecException {
        this.errorCode = 0;
        StringBuilder url = new StringBuilder("/params/set.cgi?");
        if (useTitle && title != null) {
            title = title.replace("+", "%20");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-1.Enable=True");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-1.Alignment=Top%20left");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-1.Text=").append(title);
        } else {
            url.append("&Video-").append(videoSourceNumber).append(".Osd-1.Enable=False");
        }
        if (useDateTime) {
            url.append("&Video-").append(videoSourceNumber).append(".Osd-2.Enable=True");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-2.Alignment=Bottom%20left");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-2.Text=DT(%25Y-%25m-%25d%20%25H:%25M:%25S)");
        } else {
            url.append("&Video-").append(videoSourceNumber).append(".Osd-2.Enable=False");
        }
        this.networkParameter = this.getDeviceCnf().getNetworkParameter();
        String urlString = url.toString().trim();
        urlString = urlString.replace("?&", "?");
        this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlString, (int)Integer.MAX_VALUE);
        if (this.result == null) {
            throw new SeeTecException(-20100, "Could not set On Screen Display for " + this);
        }
        String resultString = new String(this.result);
        if (resultString.toLowerCase().contains("unauthorized")) {
            throw new SeeTecException(-21657, "Error using authorization");
        }
        this.logger.info("Firmware version for " + this + ": " + this.getFirmwareVersion());
        this.globalParametersSet = true;
        return this.errorCode;
    }

    public boolean isGlobalParametersSet() {
        return this.globalParametersSet;
    }

    public static int getNTSC() {
        return 2;
    }

    public static int getPAL() {
        return 1;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

