/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.flir;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.flir.FlirHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.flir.FlirHardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.flir.FlirVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class FlirCameraSrv
extends LiveCameraSrv {
    private FlirHardwareMotionDetectionCnf flirHardwareMotionDetectionCnf;
    private final HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf = new HardwareMotionDetectionCnf[1];
    private boolean motionDetectionAlreadyStarted = false;
    private boolean imageFlipAlreadySet = false;
    private final Object SYNC_OBJ = new Object();

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        FlirVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [ VideoSourceClient ] with VideoProfileHandler=" + listener + " ...");
        try {
            int errorCode;
            videoSourceClient = new FlirVideoSourceClient();
            if (this.getVideoSourceCnf().isEnableTampering()) {
                long[] nTypeList = new long[]{9808L};
                Entity[] entities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, nTypeList);
                if (!this.motionDetectionAlreadyStarted && entities.length == 0) {
                    this.motionDetectionAlreadyStarted = true;
                    this.logger.info("Starting Tampering Detection for " + this);
                    this.flirHardwareMotionDetectionCnf = new FlirHardwareMotionDetectionCnf();
                    this.hardwareMotionDetectionCnf[0] = this.flirHardwareMotionDetectionCnf;
                    this.hardwareMotionDetection = new FlirHardwareMotionDetection();
                    this.hardwareMotionDetection.init(this, this.hardwareMotionDetectionCnf);
                }
            }
            if ((errorCode = videoSourceClient.init(core, this, listener)) != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [ VideoSourceClient ] for " + this + " failed with error [ " + errorCode + " ] :-( ");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        byte[] doubleLine = new byte[]{13, 10, 13, 10};
        try {
            String url = "/video.jpg";
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE);
            if (result != null) {
                int firstDoubleLineDelimiter = Basic.indexOfByteArray((byte[])result, (byte[])doubleLine, (int)0);
                byte[] frame = new byte[result.length - firstDoubleLineDelimiter];
                System.arraycopy(result, firstDoubleLineDelimiter, frame, 0, frame.length);
                return new ContentFrame(0, frame);
            }
            this.logger.error("Error while requesting snapshot for " + this.getDevice());
            throw new SeeTecException(-20001, "Unknown exception while requesting snapshot");
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while requesting snapshot for " + this.getDevice(), (Throwable)e);
            throw e;
        }
        catch (Exception ex) {
            this.logger.error("Exception while requesting snapshot for " + this.getDevice());
            this.logger.error((Object)ex, (Throwable)ex);
            throw new SeeTecException(-20001, "Unknown exception while requesting snapshot");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setImageFlip(int rotationAngle) throws ConfigurationException, SeeTecException {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            if (this.imageFlipAlreadySet) {
                return 0;
            }
            String flip = rotationAngle == 180 ? "True" : "False";
            String imageFlipURL = "/params/set.cgi?Video-1.Input-1.MirrorHorizontal=" + flip + "&Video-1.Input-1.MirrorVertical=" + flip;
            NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)imageFlipURL, (int)Integer.MAX_VALUE);
            this.imageFlipAlreadySet = true;
            return 0;
        }
    }
}

