/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.etrovision;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionAlarmHandler;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionAlarmHandlerIntf;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionDevice;
import org.apache.logging.log4j.LogManager;

public class EtrovisionMotionDetectionHandler
extends MotionDetectionHandler
implements EtrovisionAlarmHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.etrovision.EtrovisionMotionDetectionHandler";
    private EtrovisionDevice etrovisionDevice;
    private EtrovisionAlarmHandler etrovisionAlarmHandler;

    public EtrovisionMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        this.etrovisionDevice = (EtrovisionDevice)this.listener.getVideoSrv().getDevice();
        this.etrovisionAlarmHandler = this.etrovisionDevice.getAlarmHandler();
        this.etrovisionAlarmHandler.register(this);
        if (this.etrovisionAlarmHandler == null) {
            this.logger.error("Could not initialize Alarm Handling for " + this);
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.etrovisionAlarmHandler.deregister(this);
        super.shutdown();
        return 0;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.video.etrovision.EtrovisionMotionDetectionHandler@" + Integer.toHexString(this.hashCode());
        return "[ " + sThis.substring(sThis.lastIndexOf(46) + 1) + ", [ " + (this.listener == null ? "" : this.listener.getVideoSrv()) + " ] ]";
    }

    @Override
    public void receiveAlarm(int number, int value) {
        if (value > 0) {
            this.listener.evaluateWindow(number);
        }
    }

    @Override
    public String getAlarmType() {
        return "md";
    }

    @Override
    public void deregister() {
        this.etrovisionAlarmHandler = null;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.init(this.listener);
    }

    public void sendStatusService(int statusCode) {
        if (statusCode != 0) {
            this.logger.error("Error while retrieving Motion Detection data over HTTP for " + this);
            this.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.listener.notifyForNetworkProblems();
    }
}

