/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.etrovision;

import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionAlarmHandler;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionAlarmHandlerIntf;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;

public class EtrovisionIOHandler
extends IOHandler
implements EtrovisionAlarmHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.etrovision.EtrovisionIOHandler";
    private EtrovisionDevice etrovisionDevice = null;
    private EtrovisionAlarmHandler etrovisionAlarmHandler = null;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        this.etrovisionDevice = (EtrovisionDevice)this.device;
        this.createEtrovisionAlarm();
    }

    @Override
    public int writeDigitalOutput(int nOutputNumber, int value, long holdTime) {
        int errorCode = 0;
        DigitalOutputSrv service = super.getDigitalOutputSrv(nOutputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + nOutputNumber + "] :-(");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + nOutputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            String url = "";
            url = "/config/io.cgi?out" + nOutputNumber;
            url = value > 0 ? url + "=on" : url + "=off";
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nOutputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot write value [" + value + "] to output [" + nOutputNumber + "] :-(");
        }
    }

    @Override
    protected int discard() {
        if (this.etrovisionAlarmHandler != null) {
            this.etrovisionAlarmHandler.deregister(this);
        }
        return 0;
    }

    @Override
    public void receiveAlarm(int number, int value) {
        if (super.getDigitalInputSrv().length > number + 1) {
            super.getDigitalInputSrv()[2 * number].checkInput(value);
            super.getDigitalInputSrv()[2 * number + 1].checkInput(value);
        }
    }

    @Override
    public String getAlarmType() {
        return "input";
    }

    @Override
    public void deregister() {
        if (this.etrovisionAlarmHandler != null) {
            this.etrovisionAlarmHandler = null;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createEtrovisionAlarm();
    }

    private void createEtrovisionAlarm() {
        this.etrovisionAlarmHandler = this.etrovisionDevice.getAlarmHandler();
        this.etrovisionAlarmHandler.register(this);
        if (this.etrovisionAlarmHandler == null) {
            this.logger.error("Could not initialize Alarm Handling for " + this);
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.logger.warn("Network Problems for " + this);
    }
}

