/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.etrovision;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionAlarmHandler;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionIOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;

public class EtrovisionDevice
extends VideoServer {
    private EtrovisionIOHandler etrovisionIOHandler;
    private EtrovisionAlarmHandler etrovisionAlarmHandler;
    private HashMap<String, String> parametersOnCamera;
    private final Object SEMAPHORE = new Object();

    @Override
    public int initializeDevice(long nSrvType) {
        super.initializeDevice(nSrvType);
        this.parametersOnCamera = new HashMap();
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        this.etrovisionIOHandler = new EtrovisionIOHandler();
        return this.etrovisionIOHandler;
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public int setDeviceParameters(int rtspPort) {
        try {
            int rtspPortOnCamera = Integer.parseInt(this.readParameter("/config/stream.cgi", "rtsp_port", true));
            if (rtspPortOnCamera != rtspPort) {
                String streamName = this.readParameter("/config/stream.cgi", "stream_name");
                String maxClient = this.readParameter("/config/stream.cgi", "max_client");
                String url = "/config/stream.cgi?stream_name=" + streamName + "&max_client=" + maxClient + "&rtsp_port=" + rtspPort;
                NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            }
        }
        catch (ConfigurationException ex) {
            this.logger.info("Exception while setting RTSP-Port for " + this + ": " + ex.getMessage());
            return -20100;
        }
        catch (SeeTecException ex) {
            this.logger.info("Exception while setting RTSP-Port for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    public String readParameter(byte[] result, String parameter) {
        String[] allLines = new String(result).split("\r\n");
        for (int i = 0; i < allLines.length; ++i) {
            String[] nameValue = allLines[i].split("=");
            if (!nameValue[0].equals(parameter)) continue;
            return nameValue[1];
        }
        return "";
    }

    public String readParameter(String url, String parameter) throws SeeTecException, ConfigurationException {
        return this.readParameter(url, parameter, false, null);
    }

    public String readParameter(String url, String parameter, boolean fetch) throws SeeTecException, ConfigurationException {
        return this.readParameter(url, parameter, fetch, null);
    }

    public String readParameter(String url, String parameter, String section) throws SeeTecException, ConfigurationException {
        return this.readParameter(url, parameter, false, section);
    }

    public String readParameter(String url, String parameter, boolean fetch, String section) throws SeeTecException, ConfigurationException {
        String parametersToCheck = null;
        parametersToCheck = this.parametersOnCamera.get(url);
        if (parametersToCheck == null || fetch) {
            parametersToCheck = new String(NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE, (boolean)false, (String)"}"));
        }
        this.parametersOnCamera.put(url, parametersToCheck);
        String[] headerAndBody = parametersToCheck.split("\r\n\r\n");
        if (headerAndBody.length > 1) {
            String[] allLines;
            String body = headerAndBody[1];
            if (section != null) {
                body = this.getSubstring(body, section + "\":[", "]");
            }
            if ((allLines = body.replace("\"", "").replace("{", "").replace("}", "").split(", ")).length > 0) {
                for (int i = 0; i < allLines.length; ++i) {
                    String[] splittedLine;
                    if (allLines[i].indexOf(parameter) == -1 || (splittedLine = allLines[i].split(":")).length != 2) continue;
                    return splittedLine[1];
                }
            }
        }
        return "";
    }

    private String getSubstring(String string, String start, String end) {
        int startIndex = string.indexOf(start) + start.length();
        int endIndex = string.indexOf(end, startIndex);
        if (startIndex > -1 && endIndex > -1 && endIndex > startIndex) {
            return string.substring(startIndex, endIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EtrovisionAlarmHandler getAlarmHandler() {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            if (this.etrovisionAlarmHandler == null || this.etrovisionAlarmHandler.isShutdown()) {
                this.etrovisionAlarmHandler = new EtrovisionAlarmHandler();
            }
            this.etrovisionAlarmHandler.init(this);
            return this.etrovisionAlarmHandler;
        }
    }

    void notifyForNetworkProblems() {
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

