/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.etrovision;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionCameraControl;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionDevice;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionVideoSourceClientxx5x;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionVideoSourceClientxx8x;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EtrovisionCameraSrv
extends LiveCameraSrv {
    private final Object SEMAPHORE = new Object();
    private final Map<Integer, Integer> streams = new HashMap<Integer, Integer>();
    private final ArrayList<RTSPHandlerSuper> rtspHandlers = new ArrayList();
    private int numberOfStreams;
    private boolean parameterUnchanged = true;
    private RTSPStreamSettings rtspSettings;

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new EtrovisionCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        long deviceType = this.getDevice().getDeviceType();
        StreamingVideoSourceClientRTSP videoSourceClient = deviceType == 204605L || deviceType == 204705L || deviceType == 204805L ? new EtrovisionVideoSourceClientxx5x() : new EtrovisionVideoSourceClientxx8x();
        try {
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStreamConfiguration(VideoProfileHandler currentVideoProfileHandler) throws SeeTecException, ConfigurationException {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            this.parameterUnchanged = true;
            this.numberOfStreams = 1;
            if (this.getAdditionalVideoProfileHandler() != null) {
                this.numberOfStreams += this.getAdditionalVideoProfileHandler().length;
            }
            VideoProfileHandler[] videoProfileHandlerList = new VideoProfileHandler[this.numberOfStreams];
            videoProfileHandlerList[0] = this.getBasicVideoProfileHandler();
            if (this.numberOfStreams > 1) {
                for (int i = 1; i < this.numberOfStreams; ++i) {
                    videoProfileHandlerList[i] = this.getAdditionalVideoProfileHandler()[i - 1];
                }
            }
            VideoProfileHandler[] videoProfileHandlers = this.sort(videoProfileHandlerList);
            if (this.streams.isEmpty()) {
                for (int i = 0; i < videoProfileHandlers.length; ++i) {
                    this.streams.put(videoProfileHandlers[i].getDynamicVideoProfileID(), i + 1);
                }
            }
            StringBuilder dynamicUrl = new StringBuilder("/config/video.cgi?");
            for (int i = 0; i < videoProfileHandlers.length; ++i) {
                String parameters = this.getStreamParameters(videoProfileHandlers[i], i + 1, videoProfileHandlers.length);
                dynamicUrl.append(parameters);
            }
            String url = dynamicUrl.toString();
            if (!this.parameterUnchanged) {
                String captureModeString = this.getCaptureModeString();
                if (!captureModeString.isEmpty()) {
                    url = url + "&sensor_mode=" + this.getCaptureModeString();
                }
                url = url.replace("?&", "?");
                this.logger.info("setting parameters: " + url);
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.device.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)false);
                this.logger.info("result from setting parameters: " + new String(result));
            }
            return 0;
        }
    }

    private String getStreamParameters(VideoProfileHandler videoProfileHandler, int stream, int numberOfStreams) throws ConfigurationException, SeeTecException {
        EtrovisionDevice etrovisionDevice = (EtrovisionDevice)this.device;
        StringBuilder url = new StringBuilder();
        VideoSourceParameter v = videoProfileHandler.getVideoSourceParameter();
        String qualityString = "";
        int quality = v.getQuality();
        int bitrate = v.getBandWidth() / 1024;
        float[] bitrates = new float[]{1000.0f, 1500.0f, 2000.0f, 3000.0f, 4000.0f, 6000.0f, 8000.0f, 10000.0f, 12000.0f};
        bitrate = (int)this.convertToCameraValues(bitrates, bitrate);
        int framerate = (int)(videoProfileHandler.getFramerate() / 1000L);
        if (numberOfStreams > 2) {
            framerate = framerate > 10 ? 10 : framerate;
        }
        int n = framerate = framerate < 1 ? 1 : framerate;
        qualityString = quality < 20000 ? "bad" : (quality < 40000 ? "poor" : (quality < 60000 ? "normal" : (quality < 80000 ? "good" : "excellent")));
        int iFrameDistance = (int)((float)(framerate * v.getIFrameDistance()) / 1000.0f);
        iFrameDistance = (double)iFrameDistance <= 0.75 * (double)framerate ? (int)(0.5 * (double)framerate) : ((double)iFrameDistance <= 1.5 * (double)framerate ? framerate : (iFrameDistance <= 3 * framerate ? 2 * framerate : 4 * framerate));
        iFrameDistance = iFrameDistance < 1 ? 1 : iFrameDistance;
        url.append("&resolution_p").append(stream).append("=").append(this.getImageSize(v)[0]).append("x").append(this.getImageSize(v)[1]);
        url.append("&framerate_p").append(stream).append("=").append(framerate);
        url.append("&osd_p").append(stream).append("=");
        if (v.useTitle() || v.isTimeDateEnabled()) {
            url.append("on");
        } else {
            url.append("off");
        }
        if (v.getMediaCodec() == Codec.MJPEG) {
            url.append("&gopsize_p").append(stream).append("=20");
            url.append("&codec_p").append(stream).append("=MJPEG");
            url.append("&quality_p").append(stream).append("=").append(qualityString);
        } else {
            url.append("&codec_p").append(stream).append("=H264");
            url.append("&gopsize_p").append(stream).append("=").append(iFrameDistance);
            if (v.getBandwidthControl() == 1) {
                url.append("&ratecontrol_p").append(stream).append("=CBR");
                url.append("&bitrate_p").append(stream).append("=").append(bitrate);
            } else {
                url.append("&ratecontrol_p").append(stream).append("=VBR");
                url.append("&quality_p").append(stream).append("=").append(qualityString);
            }
        }
        boolean useOsd = v.isTimeDateEnabled() || v.useTitle();
        boolean useOsdOnCamera = etrovisionDevice.readParameter("/config/video.cgi", "osd", true, "profile_id_" + stream).equals("on");
        boolean bl = this.parameterUnchanged = this.parameterUnchanged && useOsd == useOsdOnCamera;
        if (v.getMediaCodec() == Codec.H264) {
            boolean bl2 = this.parameterUnchanged = this.parameterUnchanged && etrovisionDevice.readParameter("/config/video.cgi", "resolution", "profile_id_" + stream).equals(this.getImageSize(v)[0] + "x" + this.getImageSize(v)[1]) && etrovisionDevice.readParameter("/config/video.cgi", "framerate", "profile_id_" + stream).equals("" + framerate) && etrovisionDevice.readParameter("/config/video.cgi", "codec", "profile_id_" + stream).equals("H264") && etrovisionDevice.readParameter("/config/video.cgi", "gopsize", "profile_id_" + stream).equals("" + iFrameDistance);
            this.parameterUnchanged = v.getBandwidthControl() == 1 ? this.parameterUnchanged && etrovisionDevice.readParameter("/config/video.cgi", "ratecontrol", "profile_id_" + stream).equals("CBR") && etrovisionDevice.readParameter("/config/video.cgi", "bitrate", "profile_id_" + stream).equals("" + bitrate) : this.parameterUnchanged && etrovisionDevice.readParameter("/config/video.cgi", "ratecontrol", "profile_id_" + stream).equals("VBR") && etrovisionDevice.readParameter("/config/video.cgi", "quality", "profile_id_" + stream).equals(qualityString);
        } else {
            this.parameterUnchanged = this.parameterUnchanged && etrovisionDevice.readParameter("/config/video.cgi", "resolution", true, "profile_id_" + stream).equals(this.getImageSize(v)[0] + "x" + this.getImageSize(v)[1]) && etrovisionDevice.readParameter("/config/video.cgi", "framerate", "profile_id_" + stream).equals("" + framerate) && etrovisionDevice.readParameter("/config/video.cgi", "codec", "profile_id_" + stream).equals("MJPEG") && etrovisionDevice.readParameter("/config/video.cgi", "quality", "profile_id_" + stream).equals(qualityString);
        }
        return url.toString();
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    int setVideoSourceParameters(int rotateDegrees) {
        try {
            EtrovisionDevice etrovisionDevice = (EtrovisionDevice)this.getDevice();
            boolean rotate = rotateDegrees == 180;
            boolean flip = etrovisionDevice.readParameter("/config/sensor.cgi", "flip").equals("on");
            boolean mirror = etrovisionDevice.readParameter("/config/sensor.cgi", "mirror").equals("on");
            if (rotate && (!flip || !mirror) || !rotate && (flip || mirror)) {
                StringBuilder url = new StringBuilder("/config/sensor.cgi?");
                if (rotate) {
                    url.append("mirror=on&flip=on");
                } else {
                    url.append("mirror=off&flip=off");
                }
                this.logger.info("setting parameters for image flipping: " + url);
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                this.logger.info("result from setting image flipping: " + new String(result));
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting Videosource parameters for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while setting Videosource parameters for " + this + " : " + ex.getMessage());
            return -20100;
        }
        return 0;
    }

    public int getStreamNumber(int dynamicVideoProfileId) {
        return this.streams.get(dynamicVideoProfileId);
    }

    protected final float convertToCameraValues(float[] allowedValues, float valueToConvert) {
        float result = -2.1474836E9f;
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] > valueToConvert) {
                if (i == 0) {
                    result = allowedValues[0];
                    break;
                }
                float middle = (allowedValues[i] + allowedValues[i - 1]) / 2.0f;
                result = valueToConvert > middle ? allowedValues[i] : allowedValues[i - 1];
                break;
            }
            result = i == allowedValues.length - 1 ? allowedValues[allowedValues.length - 1] : valueToConvert;
        }
        return result;
    }

    private String getCaptureModeString() {
        try {
            String captureMode = this.device.getDeviceCnf().getCaptureMode().getDisplayResolution();
            if (this.device.getDeviceType() == 204600L || this.device.getDeviceType() == 204700L) {
                return "1mp";
            }
            if (this.device.getDeviceType() == 204604L) {
                return "1080p";
            }
            if (captureMode.equalsIgnoreCase("5mp")) {
                return "5mp";
            }
            if (captureMode.equalsIgnoreCase("3mp")) {
                return "3mp";
            }
            if (captureMode.equalsIgnoreCase("2mp (1080p)")) {
                return "1080p";
            }
            if (captureMode.equalsIgnoreCase("1.3mp")) {
                return "1mp";
            }
            return "720pb";
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while reading device configuration for " + this + ": " + ex.getMessage());
            return null;
        }
    }

    public synchronized void addRTSPHandler(RTSPHandlerSuper rtspHandler) {
        this.logger.error("------------>  ADD TO THE LIST OF:   " + (rtspHandler != null ? rtspHandler.toString() : ""));
        this.rtspHandlers.add(rtspHandler);
        this.logger.info("Adding RTSP-Handler. New lenght of RTSP-Handler-Stack: " + this.rtspHandlers.size());
    }

    public synchronized void removeRTSPHandler(RTSPHandlerSuper rtspHandler) {
        this.logger.error("------------>  REMOVE FROM THE LIST:   " + (rtspHandler != null ? rtspHandler.toString() : ""));
        this.rtspHandlers.remove(rtspHandler);
        this.logger.info("Removing RTSP-Handler. New lenght of RTSP-Handler-Stack: " + this.rtspHandlers.size());
    }

    private VideoProfileHandler[] sort(VideoProfileHandler[] videoProfileHandler) {
        if (videoProfileHandler.length == 1) {
            return videoProfileHandler;
        }
        ArrayList<VideoProfileHandler> al = new ArrayList<VideoProfileHandler>();
        al.addAll(Arrays.asList(videoProfileHandler));
        VideoProfileHandler[] sorted = new VideoProfileHandler[videoProfileHandler.length];
        try {
            for (int i = 0; i < sorted.length; ++i) {
                int maxWidth = ((VideoProfileHandler)al.get(0)).getVideoSourceParameter().getImageSize()[0];
                int profileHandlerToAdd = 0;
                for (int j = 0; j < al.size(); ++j) {
                    if (((VideoProfileHandler)al.get(j)).getVideoSourceParameter().getImageSize()[0] <= maxWidth) continue;
                    profileHandlerToAdd = j;
                }
                sorted[i] = (VideoProfileHandler)al.get(profileHandlerToAdd);
                al.remove(profileHandlerToAdd);
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("configuration exception while sorting profile handler list for " + this);
        }
        return sorted;
    }

    protected final int[] getImageSize(VideoSourceParameter v) throws SeeTecException, ConfigurationException {
        int[] imageSize = v.getImageSize();
        int deflicker = Integer.parseInt(((EtrovisionDevice)this.device).readParameter("/config/sensor.cgi", "deflicker"));
        return this.getImageSize(imageSize, deflicker);
    }

    protected final int[] getImageSize(int[] imageSize, int deflicker) {
        if (deflicker == 60 && imageSize[0] == 736 && imageSize[1] == 576) {
            return new int[]{736, 480};
        }
        return imageSize;
    }
}

