/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.etrovision;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Vector;

public class EtrovisionCameraControl
extends CameraControl {
    int errorCode = 0;
    private String oldUrl;

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        StringBuilder sb = new StringBuilder(256);
        int pan = 0;
        int tilt = 0;
        int zoom = 0;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        if (panSpeed != null || tiltSpeed != null || zoomSpeed != null) {
            if (this.videoSrv.getDevice().getDeviceType() == 204605L || this.videoSrv.getDevice().getDeviceType() == 204705L || this.videoSrv.getDevice().getDeviceType() == 204805L) {
                sb.append("/config/ptz_move_cont.cgi?p=" + this.calculateSpeed4Encoder(pan) + "&t=" + this.calculateSpeed4Encoder(tilt) + "&z=" + this.calculateSpeed4Encoder(zoom));
            } else {
                sb.append("/config/ptz_move_cont.cgi?pp=" + this.calculateSpeed(pan) + "&tt=" + this.calculateTiltSpeed(tilt) + "&zz=" + this.calculateSpeed(zoom));
            }
            this.videoSrv.notifyForCameraControl();
            try {
                if (!sb.toString().equals(this.oldUrl)) {
                    this.oldUrl = sb.toString();
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while sending PTZ command for " + this + " : " + ex.getMessage());
                return ex.getErrorCode();
            }
        }
        return 0;
    }

    private int calculateSpeed4Encoder(int speed) {
        return speed / 16666;
    }

    private int calculateSpeed(int speed) {
        if (Math.abs(speed) < 10000) {
            return 0;
        }
        return speed / 1666;
    }

    private int calculateTiltSpeed(int speed) {
        if (speed == 0) {
            return 0;
        }
        int tiltSpeed = speed / 10000;
        if (tiltSpeed == 0) {
            if (speed > 0 && speed < 1000) {
                tiltSpeed = 1;
            }
            if (speed < 0 && speed > -1000) {
                tiltSpeed = -1;
            }
        }
        return tiltSpeed;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer heigth, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousIris(Integer value) {
        try {
            this.setAutoIris(false);
            String url = "/config/iris.cgi?i=";
            url = value > 0 ? url + 6 : (value < 0 ? url + -6 : url + 0);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while sending Iris command for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/config/ptz_autoiris.cgi?autoiris=" + (active != false ? "yes" : "no")), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exceptions while changing autofocus setting for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousFocus(Integer value) {
        try {
            this.setAutoFocus(false);
            String url = "/config/focus_cont.cgi?f=";
            url = value > 0 ? url + 20 : (value < 0 ? url + -20 : url + 0);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while sending Focus command for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/config/ptz_autofocus.cgi?autofocus=" + (active != false ? "yes" : "no")), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exceptions while changing autofocus setting for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/config/dn_set.cgi?dn_mode=" + (active != false ? "night" : "day") + "&dn_bw=off"), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while changing day/night mode for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        if (active.booleanValue()) {
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/config/dn_set.cgi?dn_mode=auto", (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while enabling auto day/night mode for " + this + " : " + ex.getMessage());
                return ex.getErrorCode();
            }
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            byte[] vector = new byte[256];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i < vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [ " + presetName + " ], 'cause no more free preset positions are available for " + this + " :-( ");
                return -21600;
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/config/ptz_preset.cgi?name=" + presetPosition + "&act=add"), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while adding preset position for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [ " + presetName + " ] failed :-( ");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/config/ptz_preset.cgi?name=" + presetCnf.getPresetPosition() + "&act=go"), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                return 0;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while navigating to preset position for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [ " + presetName + " ] failed :-( ");
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available :-( ");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                String presetNumber = presetCnf.getPresetPosition();
                this.presetList.removeElementAt(i);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/config/ptz_preset.cgi?name=" + presetNumber + "&act=del"), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                if (this.errorCode != 0) {
                    this.logger.warn("Removing preset [ " + presetCnf.getPresetName() + " ] from " + this + " failed with error [ " + this.errorCode + " ] :-( ");
                }
                return 0;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while deleting preset position for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [ " + presetName + " ] failed :-( ");
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available :-( ");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

