/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.etrovision;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionAlarmHandlerIntf;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionDevice;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtrovisionAlarmHandler
extends Basic
implements Runnable,
HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.etrovision.EtrovisionnAlarmHandler";
    private Thread myThread = null;
    private NetworkParameter networkParameter = null;
    private EtrovisionDevice etrovisionDevice;
    protected Logger logger = null;
    private final ArrayList<EtrovisionAlarmHandlerIntf> callback = new ArrayList();
    private HttpServerPushHandler httpServerPushHandler;
    private boolean shutdown;

    public EtrovisionAlarmHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    public int init(EtrovisionDevice etrovisionDevice) {
        this.shutdown = false;
        if (this.httpServerPushHandler != null) {
            return 0;
        }
        this.etrovisionDevice = etrovisionDevice;
        try {
            this.networkParameter = this.etrovisionDevice.getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration Exception for " + this);
            return -20103;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    @Override
    public void run() {
        String motionDetectionURL = "/config/notify_stream.cgi";
        this.httpServerPushHandler = new HttpServerPushHandler();
        int errorCode = 0;
        errorCode = this.httpServerPushHandler.init(this, this.networkParameter, motionDetectionURL);
        if (errorCode != 0) {
            this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
            this.shutdown();
        } else {
            errorCode = this.httpServerPushHandler.startServerPush(true);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "] width " + this.httpServerPushHandler);
                this.shutdown();
            }
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.video.etrovision.EtrovisionnAlarmHandler@" + Integer.toHexString(this.hashCode());
        return "[ " + sThis.substring(sThis.lastIndexOf(46) + 1) + " ]";
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (statusCode != 0) {
            this.logger.error("Error while retrieving Motion Detection data over HTTP for " + this);
            try {
                if (statusCode == HTTPStatusCode.HTTP_FORBIDDEN.getStatusCode()) {
                    this.logger.error("Camera does not respond properly because of too many configuration changes. Rebooting... ");
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/config/system_reboot.cgi", (int)Integer.MAX_VALUE, (boolean)true);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while restarting camera for " + this);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.logger.error("Network problems for " + this);
        for (int i = 0; i < this.callback.size(); ++i) {
            this.callback.get(i).notifyForNetworkProblems();
        }
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public void deliverContent(HttpServerPushContent data) {
        String[] alarmData;
        if (data == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("\r\n" + new String(data.getContentBody()));
        }
        if ((alarmData = new String(data.getContentBody()).split("\r\n")).length == 0) {
            return;
        }
        for (int i = 0; i < alarmData.length; ++i) {
            for (int j = 0; j < this.callback.size(); ++j) {
                String[] alarmParams;
                String alarm = alarmData[i];
                EtrovisionAlarmHandlerIntf actualCallback = this.callback.get(j);
                String alarmType = actualCallback.getAlarmType();
                if (!alarm.startsWith(alarmType) || (alarmParams = (alarm = alarm.replace(alarmType, "")).split("=")).length != 2) continue;
                int number = Integer.parseInt(alarmParams[0]);
                int value = alarmParams[1].equals("on") ? 1 : 0;
                actualCallback.receiveAlarm(number - 1, value);
            }
        }
    }

    void register(EtrovisionAlarmHandlerIntf callback) {
        this.callback.add(callback);
    }

    void deregister(EtrovisionAlarmHandlerIntf callback) {
        this.callback.remove(callback);
        if (this.callback.isEmpty()) {
            this.shutdown();
        }
    }

    public int shutdown() {
        this.shutdown = true;
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        EtrovisionAlarmHandlerIntf[] callbackArray = new EtrovisionAlarmHandlerIntf[this.callback.size()];
        this.callback.toArray(callbackArray);
        for (int i = 0; i < this.callback.size(); ++i) {
            this.callback.remove(i);
        }
        for (int j = 0; j < callbackArray.length; ++j) {
            EtrovisionAlarmHandlerIntf actualCallback = callbackArray[j];
            actualCallback.deregister();
        }
        return 0;
    }
}

