/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dynacolor;

import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public class DynacolorMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf,
Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dynacolor.DynaColorMotionDetectionHandler";
    private HttpServerPushHandler httpServerPushHandler = null;
    private NetworkParameter networkParameter = null;
    private long lastTamperingEventSent;
    private Thread myThread;
    private Socket socket = null;
    private InputStream inputStream = null;
    private Map<String, String> cameraParameters = null;
    private static final int INTERVAL = 500;

    public DynacolorMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode;
        block15: {
            errorCode = 0;
            this.listener = hardwareMotionDetection;
            if (this.listener == null) {
                return -20003;
            }
            String url = this.listener.getVideoSrv().getEntityType() == 214150L ? "/cgi-bin/admin/param.cgi?action=update&Image.I0.TriggerData.IOStatus=0" : "/cgi-bin/admin/eventdata.cgi?action=get&group=Motion,Motion1,Motion2,Motion3";
            try {
                this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            }
            catch (SeeTecException e) {
                this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv());
                this.logger.warn((Object)e, (Throwable)e);
                return e.getErrorCode();
            }
            catch (Exception e) {
                this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv());
                this.logger.warn((Object)e, (Throwable)e);
                return -20053;
            }
            if (this.listener.getVideoSrv().getEntityType() == 214150L) {
                String getParameters;
                url = "/cgi-bin/admin/param.cgi?action=list&group=Motion";
                try {
                    getParameters = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true));
                }
                catch (SeeTecException e) {
                    this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv());
                    this.logger.warn((Object)e, (Throwable)e);
                    return e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv());
                    this.logger.warn((Object)e, (Throwable)e);
                    return -20053;
                }
                this.cameraParameters = new HashMap<String, String>();
                Tools.parseParameters(this.cameraParameters, getParameters);
                try {
                    this.socket = new Socket(this.networkParameter.getHost(), 5656);
                    this.inputStream = this.socket.getInputStream();
                    this.myThread = new Thread((Runnable)this, this.toString());
                    this.myThread.start();
                }
                catch (IOException e) {
                    this.logger.error("Problem while initiating socket to " + this.listener.getVideoSrv(), (Throwable)e);
                    return -21656;
                }
            }
            try {
                try {
                    url = "/cgi-bin/admin/eventdata.cgi?action=monitor&group=Motion,Motion1,Motion2,Motion3,T0";
                    this.networkParameter.setSoTimeout(10000);
                    this.httpServerPushHandler = new HttpServerPushHandler();
                    errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url, 512, "-----eventboundary".getBytes());
                    if (errorCode != 0) {
                        this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                        break block15;
                    }
                    errorCode = this.httpServerPushHandler.startServerPush(true);
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                    this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed :-(");
                    errorCode = -21601;
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)t, t);
                errorCode = -21651;
            }
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (this.myThread != null) {
            this.myThread = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public void notifyForNetworkProblems() {
        this.logger.info("Network problem signaled for " + this.listener.getVideoSrv());
        this.sendStatusService(-21650);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        byte[] result = new byte[3];
        long time = System.currentTimeMillis();
        try {
            while (true) {
                if (this.isShutdown(CLASS_NAME)) {
                    super.setRunFinished(CLASS_NAME, true);
                    this.shutdown();
                    return;
                }
                try {
                    if (System.currentTimeMillis() - time < 500L) {
                        Thread.sleep(500L + time - System.currentTimeMillis());
                    }
                    if (this.isShutdown(CLASS_NAME)) continue;
                    if (this.socket.isConnected()) {
                        int value;
                        this.inputStream.skip(this.inputStream.available());
                        int length = this.inputStream.read(result);
                        if (length > 0 && new String(result, 2, 1).equals("$") && (value = Integer.parseInt(new String(result, 0, 2), 16)) >= Integer.parseInt(this.cameraParameters.get("root.Motion.Sensitivity")) && value < 101 && this.listener != null) {
                            this.listener.evaluateWindow(0);
                        }
                    } else {
                        this.logger.warn("Socket not connected");
                    }
                    time = System.currentTimeMillis();
                }
                catch (Throwable ex) {
                    this.logger.error("Error accessing: " + this.listener.getVideoSrv() + ". Message: " + ex.getMessage());
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Exception for " + this.listener.getVideoSrv());
            this.logger.fatal((Object)ex, ex);
            this.shutdown();
        }
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        String content = new String(httpServerPushContent.getContentBody());
        try {
            for (String parameter : content.split("\\r?\\n")) {
                if (parameter.startsWith("Motion")) {
                    String value = parameter.substring(6, 7);
                    int index = !value.equals(":") ? Integer.parseInt(value) : 0;
                    if (parameter.contains("Enabled=1") && parameter.contains("Triggered=1") && this.listener != null) {
                        this.listener.evaluateWindow(index);
                    }
                }
                if (!parameter.startsWith("T0") || !parameter.contains("Triggered=1") || this.listener == null || !this.listener.getVideoSrv().getVideoSourceCnf().isEnableTampering() || System.currentTimeMillis() <= this.lastTamperingEventSent + 10000L) continue;
                this.lastTamperingEventSent = System.currentTimeMillis();
                ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateTampering();
                this.listener.getVideoSrv().getCore().sendTamperingEvent(this.listener.getVideoSrv());
            }
        }
        catch (ConfigurationException e) {
            this.logger.error("Exception while reading motion detection or tampering data: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            this.logger.error("Exception while reading motion detection data: " + e.getMessage());
        }
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (nStatusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }
}

