/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dynacolor;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URLEncoder;
import java.util.Vector;

public class DynacolorCameraControl
extends CameraControl {
    private int sendCameraCommand(String url, boolean preset, boolean autofocus) {
        try {
            String completeURL = preset ? "/cgi-bin/com/ptzconfig.cgi?" + url : (this.videoSrv.getDevice().getDeviceType() == 204150L && autofocus ? "/cgi-bin/server_ptz.cgi?" + url : "/cgi-bin/com/ptz.cgi?" + url);
            completeURL = completeURL.replace("?&", "?");
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Sending URL=[" + completeURL + "] for " + this + " ...");
            }
            this.videoSrv.notifyForCameraControl();
            String response = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL, (int)Integer.MAX_VALUE, (boolean)true));
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Response:\n" + response);
            }
            return 0;
        }
        catch (SeeTecException t) {
            this.logger.error((Object)t, (Throwable)t);
            return -21600;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        StringBuilder url = new StringBuilder();
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed / 1000;
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed / 1000;
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed / 1000;
        } else {
            zoom = this.previousZoomSpeed;
        }
        try {
            int errorCode;
            if (panSpeed != null || tiltSpeed != null) {
                url.append("&continuouspantiltmove=").append(pan).append(",").append(tilt);
                errorCode = this.sendCameraCommand(url.toString(), false, false);
                if (errorCode != 0) {
                    this.logger.error("Error while sending PT command for " + this);
                    return errorCode;
                }
            }
            if (zoomSpeed != null) {
                url.append("&continuouszoommove=").append(zoom);
                errorCode = this.sendCameraCommand(url.toString(), false, false);
                if (errorCode != 0) {
                    this.logger.error("Error while sending Zoom command for " + this);
                    return errorCode;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error((Object)t, t);
            return -21600;
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoIris(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        this.sendCameraCommand("&autofocus=off", false, false);
        if (value < 0) {
            return this.sendCameraCommand("&continuousfocusmove=-10", false, false);
        }
        if (value > 0) {
            return this.sendCameraCommand("&continuousfocusmove=10", false, false);
        }
        return this.sendCameraCommand("&continuousfocusmove=" + value, false, false);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autofocus=on", false, true);
        }
        return this.sendCameraCommand("&autofocus=off", false, true);
    }

    @Override
    public int setZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setHomePosition() {
        return this.sendCameraCommand("&move=home", true, false);
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            String encodedPresetName = URLEncoder.encode(presetName.trim().replace(" ", "_"), "UTF-8");
            int[] freeSlots = new int[256];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                freeSlots[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i < freeSlots.length; ++i) {
                if (freeSlots[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + encodedPresetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, String.valueOf(presetPosition), encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.sendCameraCommand("&setserverpresetname=" + presetPosition + "," + encodedPresetName, true, false);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Adding preset [" + presetName + "] failed :-(");
        }
        return 0;
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim().replace(" ", "_"), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                return this.sendCameraCommand("&gotoserverpresetno=" + presetCnf.getPresetPosition(), false, false);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed :-(");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim().replace(" ", "_"), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.presetList.removeElementAt(i);
                int errorCode = this.sendCameraCommand("&removeserverpresetname=" + presetCnf.getPresetName(), true, false);
                if (errorCode != 0) {
                    this.logger.warn("Removing preset [" + presetCnf.getPresetName() + "] from " + this + " failed with error [" + errorCode + "] :-(");
                }
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed :-(");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

