/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dlink;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraPropertyChangedListener;
import de.seetec.v5.re.cm.device.video.dlink.DLinkDevice;
import org.apache.logging.log4j.LogManager;

public class DLinkMotionDetectionHandler
extends MotionDetectionHandler
implements DLinkCameraPropertyChangedListener {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqle.DLinkMotionDetectionHandler";
    private DLinkDevice dLinkDevice;
    public static final int MOTION_THRESHOLD = 60;

    public DLinkMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        this.dLinkDevice = (DLinkDevice)this.listener.getVideoSrv().getDevice();
        this.dLinkDevice.getCameraPropertyChangedHandler().register(this);
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.dLinkDevice.getCameraPropertyChangedHandler().deregister(this);
        super.shutdown();
        return 0;
    }

    public void sendStatusService(int statusCode) {
        if (statusCode != 0) {
            this.logger.error("Error while retrieving Motion Detection data over HTTP for " + this);
        }
    }

    @Override
    public String[] getRegisteredProperties() {
        return new String[]{"mdv"};
    }

    @Override
    public void propertyChangedEvent(String property, String value) {
        if (Integer.parseInt(value) > 60) {
            this.listener.evaluateWindow(0);
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.video.iqle.DLinkMotionDetectionHandler@" + Integer.toHexString(this.hashCode());
        return "[ " + sThis.substring(sThis.lastIndexOf(46) + 1) + ", [ " + (this.listener == null ? "" : this.listener.getVideoSrv()) + " ] ]";
    }
}

