/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dlink;

import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraPropertyChangedListener;
import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraPropertyHandler;
import de.seetec.v5.re.cm.device.video.dlink.DLinkDevice;
import de.seetec.v5.re.cm.device.video.dlink.DLinkNetworkHelper;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLinkCameraPropertyChangedHandler
extends Thread {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final DLinkDevice device;
    private boolean shutdown = false;
    private boolean debug = false;
    private Properties properties = new Properties();
    private final List<DLinkCameraPropertyChangedListener> registeredListener = new ArrayList<DLinkCameraPropertyChangedListener>();
    private HttpURLConnection connection;

    public DLinkCameraPropertyChangedHandler(DLinkDevice device) {
        this.device = device;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.device.getCameraPropertyHandler().load(DLinkCameraPropertyHandler.CATEGORY.NOTIFICATION_SETTINGS);
            this.properties = this.device.getCameraPropertyHandler().getProperties(DLinkCameraPropertyHandler.CATEGORY.NOTIFICATION_SETTINGS);
        }
        catch (SeeTecException ex) {
            this.logger.error("Error occured while loading notification settings! Message: " + ex.getMessage());
        }
        boolean error = false;
        while (!this.shutdown) {
            try {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.logger.info("Connecting to the notification stream...");
                this.connection = DLinkNetworkHelper.getHttpURLConnection(this.device.getDeviceCnf().getNetworkParameter(), "/config/notify_stream.cgi");
                this.connection.setReadTimeout(10000);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.length() <= 0 || !line.contains("=")) continue;
                        String key = line.substring(0, line.indexOf("="));
                        String newValue = line.substring(line.indexOf("=") + 1, line.length());
                        String oldValue = this.properties.getProperty(key);
                        if (this.debug) {
                            this.logger.info("DLinkPropertyChangedCallbackHandler -> " + key + "=" + newValue);
                        }
                        if (newValue.equals(oldValue)) continue;
                        if (this.debug) {
                            this.logger.info("DLinkPropertyChangedCallbackHandler -> " + key + " has changed from " + oldValue + " to " + newValue);
                        }
                        List<DLinkCameraPropertyChangedListener> list = this.registeredListener;
                        synchronized (list) {
                            for (DLinkCameraPropertyChangedListener r : this.registeredListener) {
                                for (String p : r.getRegisteredProperties()) {
                                    if (!key.startsWith(p)) continue;
                                    r.propertyChangedEvent(key, newValue);
                                }
                            }
                        }
                        this.properties.setProperty(key, newValue);
                    }
                }
            }
            catch (SocketTimeoutException te) {
                this.logger.debug("SocketTimeoutException: " + te.getMessage());
            }
            catch (ConnectException ce) {
                this.logger.error("Connection to camera lost! Message: " + ce.getMessage());
                error = true;
            }
            catch (Exception ex) {
                this.logger.error("Exception in DLinkStatusNotificationHandler! Message: " + ex.getMessage());
                error = true;
            }
            if (!error) continue;
            error = false;
            try {
                DLinkCameraPropertyChangedHandler ex = this;
                synchronized (ex) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException ex) {
                this.logger.info("DLinkCameraPropertyChangedHandler interrupted!", (Throwable)ex);
            }
        }
        this.logger.info("DLinkCameraPropertyChangedHandler ended!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.registeredListener.clear();
        this.shutdown = true;
        if (this.connection != null) {
            this.connection.disconnect();
        }
        DLinkCameraPropertyChangedHandler dLinkCameraPropertyChangedHandler = this;
        synchronized (dLinkCameraPropertyChangedHandler) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(DLinkCameraPropertyChangedListener receiver) {
        List<DLinkCameraPropertyChangedListener> list = this.registeredListener;
        synchronized (list) {
            if (!this.registeredListener.contains(receiver)) {
                this.registeredListener.add(receiver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(DLinkCameraPropertyChangedListener receiver) {
        List<DLinkCameraPropertyChangedListener> list = this.registeredListener;
        synchronized (list) {
            if (this.registeredListener.contains(receiver)) {
                this.registeredListener.remove(receiver);
            }
        }
    }
}

