/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dallmeier;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.dallmeier.DallmeierCameraControl;
import de.seetec.v5.re.cm.device.video.dallmeier.DallmeierDevice;
import de.seetec.v5.re.cm.device.video.dallmeier.mpeg.DallmeierMPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.dallmeier.onvif.DallmeierOnvifVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.SeeTecException;

public final class DallmeierCameraSrv
extends LiveCameraSrv {
    public static final String VIDEO_SOURCE_1 = "source1";
    public static final String VIDEO_ENCODER_1 = "encoder1";
    public static final String PTZ_CONFIGURATION_1 = "ptzconf0";
    public static final String PTZ_NODE_1 = "ptz0";

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new DallmeierCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        StreamingVideoSourceClientRTSP videoSourceClient = null;
        try {
            DallmeierDevice dallmeierDevice;
            int errorCode;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("StreamingMode for " + this + " is [" + this.getVideoSourceCnf().getMediaCodec() + "]");
            }
            if ((errorCode = (videoSourceClient = (dallmeierDevice = (DallmeierDevice)this.getDevice()).isOnvifDevice() ? new DallmeierOnvifVideoSourceClient() : new DallmeierMPEGVideoSourceClient()).init(core, this, listener)) != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(", ex);
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }
}

