/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.dahua.DahuaDevice;
import de.seetec.v5.re.cm.device.video.dahua.DahuaHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;

public class DahuaMotionDetectionHandler
extends MotionDetectionHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dahua.DahuaMotionDetectionHandler";
    private Thread myThread = null;
    private NetworkParameter networkParameter = null;
    private int channelNumber;
    private static final int INTERVAL = 500;
    private boolean motionDisabled;
    private long timeOfMotion;
    private int deadTime = 30000;
    private long timeForDeadtimeMeasuring;

    public DahuaMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            this.channelNumber = this.listener.getVideoSrv().getVideoSourceCnf().getPtzAddress();
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            String url = "/cgi-bin/configManager.cgi?action=setConfig&MotionDetect[" + this.channelNumber + "].enable=true";
            ((DahuaDevice)this.listener.getVideoSrv().getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (SeeTecException e) {
            this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv(), (Throwable)e);
            return -20053;
        }
        try {
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }
        catch (Exception e) {
            this.logger.error("Problem while initiating thread for " + this.listener.getVideoSrv(), (Throwable)e);
            return -21656;
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final void run() {
        super.setRunFinished(CLASS_NAME, false);
        long time = System.currentTimeMillis();
        try {
            String url = "/cgi-bin/eventManager.cgi?action=getEventIndexes&code=VideoMotion";
            block5: while (!this.isShutdown(CLASS_NAME)) {
                try {
                    if (System.currentTimeMillis() - time < 500L) {
                        Thread.sleep(500L + time - System.currentTimeMillis());
                    }
                    if (this.isShutdown(CLASS_NAME)) continue;
                    time = System.currentTimeMillis();
                    String result = ((DahuaDevice)this.listener.getVideoSrv().getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
                    String[] mds = DahuaHelper.getParameterValues(result, "channels[0]");
                    if (mds.length > 0) {
                        if (!this.motionDisabled) {
                            this.timeForDeadtimeMeasuring = System.currentTimeMillis();
                        }
                        for (String md : mds) {
                            int channelWithMotion = 1 + Integer.parseInt(md);
                            if (System.currentTimeMillis() - this.timeOfMotion > (long)this.deadTime) {
                                this.motionDisabled = false;
                            }
                            if (channelWithMotion != this.channelNumber || this.motionDisabled) continue;
                            this.listener.evaluateWindow(0);
                            this.timeOfMotion = System.currentTimeMillis();
                            this.motionDisabled = true;
                            continue block5;
                        }
                        continue;
                    }
                    this.deadTime = (int)Math.min(System.currentTimeMillis() - this.timeForDeadtimeMeasuring + 1000L, (long)this.deadTime);
                    this.motionDisabled = false;
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while reading motion detection data for " + this + ": " + ex.getMessage());
                }
                catch (Throwable ex) {
                    this.logger.error("Error accessing: " + this.networkParameter + "  for " + this.listener.getVideoSrv() + ". Message: " + ex.getMessage());
                }
            }
            super.setRunFinished(CLASS_NAME, true);
            this.shutdown();
        }
        catch (Throwable ex) {
            this.logger.warn("Exception for " + this.listener.getVideoSrv());
            this.logger.fatal((Object)ex, ex);
            this.shutdown();
        }
    }
}

