/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.device.video.dahua.DahuaCommand;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DahuaHelper {
    private String response = null;
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final NetworkParameter networkParameter;

    static String removeNumber(String eventName) {
        if (eventName == null || eventName.isEmpty()) {
            return eventName;
        }
        int index = eventName.indexOf("[");
        if (index == -1) {
            return eventName;
        }
        return eventName.substring(0, index);
    }

    DahuaHelper(NetworkParameter networkParameter) {
        this.networkParameter = networkParameter;
    }

    public static String[] getParameterValues(String responseString, String ... parameterNames) {
        String[] ret = new String[]{};
        if (responseString != null && parameterNames != null && parameterNames.length > 0) {
            for (String parameterName : parameterNames) {
                String[] parameterList;
                parameterName = parameterName.replace("[", "\\[").replace("]", "\\]");
                for (String parameterLine : parameterList = responseString.split(new String(SSLConstantsIntf.CRLF_BYTE))) {
                    String[] parameterLineParts = parameterLine.split("=");
                    if (parameterLineParts.length != 2 || !parameterLineParts[0].toLowerCase().matches(parameterName.toLowerCase())) continue;
                    ret = parameterLineParts[1].split(",");
                    for (int j = 0; j < ret.length; ++j) {
                        ret[j] = ret[j].trim();
                    }
                    return ret;
                }
            }
        }
        return ret;
    }

    public String[] getCaps(DahuaCommand parameterGroup, String parameterName, String alternativParameterName) throws SeeTecException {
        return this.getCaps(parameterGroup, parameterName, alternativParameterName, true);
    }

    public String[] getCaps(DahuaCommand parameterGroup, String parameterName, String alternativParameterName, boolean readFromCamera) throws SeeTecException {
        String url = parameterGroup.getUrl();
        String responseString = null;
        if (!readFromCamera) {
            responseString = this.response;
        }
        if (responseString == null || readFromCamera) {
            this.response = responseString = this.getHttpHandler().readGetRequest(url);
        }
        return DahuaHelper.getParameterValues(responseString, parameterName, alternativParameterName);
    }

    public static int adaptSpeed(Integer ptzSpeed) {
        if (ptzSpeed == null) {
            return 0;
        }
        if (ptzSpeed <= -90000) {
            return -8;
        }
        if (ptzSpeed <= -80000) {
            return -7;
        }
        if (ptzSpeed <= -70000) {
            return -6;
        }
        if (ptzSpeed <= -60000) {
            return -5;
        }
        if (ptzSpeed <= -50000) {
            return -4;
        }
        if (ptzSpeed <= -40000) {
            return -3;
        }
        if (ptzSpeed <= -30000) {
            return -2;
        }
        if (ptzSpeed <= -20000) {
            return -1;
        }
        if (ptzSpeed < 20000) {
            return 0;
        }
        if (ptzSpeed < 30000) {
            return 1;
        }
        if (ptzSpeed < 40000) {
            return 2;
        }
        if (ptzSpeed < 50000) {
            return 3;
        }
        if (ptzSpeed < 60000) {
            return 4;
        }
        if (ptzSpeed < 70000) {
            return 5;
        }
        if (ptzSpeed < 80000) {
            return 6;
        }
        if (ptzSpeed < 90000) {
            return 7;
        }
        return 8;
    }

    public String[] readHttpValue(String url, String parameterName, String alternativParameterName) throws SeeTecException {
        try {
            String result = this.getHttpHandler().readGetRequest(url);
            if (result.toLowerCase().contains("detail=invalid authority")) {
                throw new SeeTecException(-21657, "Unauthorized");
            }
            return DahuaHelper.getParameterValues(result, parameterName, alternativParameterName);
        }
        catch (NullPointerException npe) {
            return new String[0];
        }
    }

    protected boolean changedHttpsSettings(NetworkParameter networkParameter) {
        return this.networkParameter.useHTTPS() != networkParameter.useHTTPS() || this.networkParameter.getHTTPport() != networkParameter.getHTTPport() || this.networkParameter.getSSLport() != networkParameter.getSSLport() || !this.networkParameter.getUserPWD()[0].equals(networkParameter.getUserPWD()[0]) || !this.networkParameter.getUserPWD()[1].equals(networkParameter.getUserPWD()[1]) || this.networkParameter.getSoTimeout() != networkParameter.getSoTimeout() || !this.networkParameter.getHost().equals(networkParameter.getHost());
    }

    protected synchronized HttpHandler getHttpHandler() {
        try {
            return new HttpHandlerImpl(this.networkParameter);
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading configuration for " + this + ": " + ex.getMessage());
            return null;
        }
    }

    public static boolean checkIsVideoCodecSet(String cameraConfiguration, int channelID, String streamName, Codec videoCodec) {
        String[] parametersOnCamera;
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty() && videoCodec != null && (parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Compression")).length == 1) {
            switch (videoCodec) {
                case H264: {
                    result = parametersOnCamera[0].toLowerCase().trim().equals("h.264");
                    break;
                }
                case H265: {
                    result = parametersOnCamera[0].toLowerCase().trim().equals("h.265");
                    break;
                }
                default: {
                    result = parametersOnCamera[0].toLowerCase().trim().equals("mjpg");
                }
            }
        }
        return result;
    }

    public static boolean checkIsVideoEnabled(String cameraConfiguration, int channelID, String streamName, int streamNumber) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".VideoEnable");
            result = streamNumber == 0 ? true : parametersOnCamera.length == 1 && parametersOnCamera[0].equalsIgnoreCase("true");
        }
        return result;
    }

    public static boolean checkIsResolutionEnabled(String cameraConfiguration, int channelID, String streamName, int height, int width) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Height");
            result = parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Integer.toString(height));
            parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Width");
            result &= parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Integer.toString(width));
        }
        return result;
    }

    public static boolean checkIsAudioSet(String cameraConfiguration, int channelID, String streamName, boolean isAudioEnabled) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".AudioEnable");
            result = parametersOnCamera.length == 1 && isAudioEnabled && parametersOnCamera[0].equalsIgnoreCase("true") || !isAudioEnabled && parametersOnCamera[0].equalsIgnoreCase("false");
        }
        return result;
    }

    public static boolean checkIsBitrateEnabled(String cameraConfiguration, int channelID, String streamName, int bitrate) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.BitRate");
            result = parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Integer.toString(bitrate));
        }
        return result;
    }

    public static boolean checkIsBitrateControlEnabled(String cameraConfiguration, int channelID, String streamName, boolean constantBitrateUsed) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.BitRateControl");
            result = parametersOnCamera.length == 1 && constantBitrateUsed && parametersOnCamera[0].toLowerCase().trim().equals("cbr") || !constantBitrateUsed && parametersOnCamera[0].toLowerCase().trim().equals("vbr");
        }
        return result;
    }

    public static boolean checkIsQualitySet(String cameraConfiguration, int channelID, String streamName, Codec videoCodec, int quality) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty() && videoCodec != null) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Quality");
            result = videoCodec == Codec.MJPEG ? true : parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Integer.toString(quality));
        }
        return result;
    }

    public static boolean checkIsIFrameDistanceSet(String cameraConfiguration, int channelID, String streamName, long iFrameDist, Codec videoCodec) {
        boolean result = false;
        if (videoCodec == Codec.MJPEG) {
            result = true;
        }
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty() && videoCodec != null) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.GOP");
            result = parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Long.toString(iFrameDist));
        }
        return result;
    }

    public static boolean checkIsProfileSet(String cameraConfiguration, int channelID, String streamName, String profileName) {
        boolean result = false;
        if (!(cameraConfiguration == null || cameraConfiguration.isEmpty() || streamName == null || streamName.isEmpty() || profileName == null || profileName.isEmpty())) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Profile");
            result = parametersOnCamera.length == 1 && parametersOnCamera[0].toLowerCase().equals(profileName.toLowerCase());
        }
        return result;
    }

    public static boolean checkIsAudioCodecSet(String cameraConfiguration, int channelID, String streamName, boolean audioEnabled, Codec audioCodec, Codec videoCodec) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty() && audioCodec != null && videoCodec != null) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Audio.Compression");
            result = !audioEnabled || videoCodec == Codec.MJPEG ? true : parametersOnCamera.length == 1 && (audioCodec.equals((Object)Codec.G711U) && parametersOnCamera[0].toLowerCase().trim().equals("g.711mu") || audioCodec.equals((Object)Codec.G711A) && parametersOnCamera[0].toLowerCase().trim().equals("g.711a"));
        }
        return result;
    }

    public static boolean checkIsRTSPPortSet(String cameraConfiguration, int rtspPort) throws SeeTecException {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.RTSP.Port");
            try {
                result = parametersOnCamera.length == 1 && Integer.parseInt(parametersOnCamera[0].trim()) == rtspPort;
            }
            catch (NumberFormatException ex) {
                throw new SeeTecException(-20033, "Error while converting String to number. String to convert: " + parametersOnCamera[0].trim());
            }
        }
        return result;
    }

    public static boolean isFirmwareGreaterOrEqual(String firmwareGiven, int mayor, int minor) throws SeeTecException {
        String[] firmwareParts;
        boolean result = false;
        if (firmwareGiven != null && !firmwareGiven.isEmpty() && (firmwareParts = firmwareGiven.split("\\.")).length >= 2) {
            int secondPart;
            int firstPart;
            try {
                firstPart = Integer.parseInt(firmwareParts[0].trim());
            }
            catch (NumberFormatException ex) {
                throw new SeeTecException(-20002, "Exception while converting string to number. String to convert: " + firmwareParts[0].trim());
            }
            try {
                secondPart = Integer.parseInt(firmwareParts[1].trim());
            }
            catch (NumberFormatException ex) {
                throw new SeeTecException(-20002, "Exception while converting string to number. String to convert: " + firmwareParts[1].trim());
            }
            if (firstPart > mayor) {
                return true;
            }
            if (firstPart < mayor) {
                return false;
            }
            return secondPart >= minor;
        }
        return result;
    }

    public static String matchNames(String triggerName) {
        if (triggerName == null || triggerName.isEmpty()) {
            return "";
        }
        switch (triggerName) {
            case "AlarmLocal": {
                return "Alarm";
            }
            case "VideoBlind": {
                return "BlindDetect[0]";
            }
            case "LoginFailure": {
                return "LoginFailureAlarm";
            }
            case "VideoLoss": {
                return "LossDetect[0]";
            }
            case "VideoMotion": {
                return "MotionDetect[0]";
            }
            case "MoveDetection": {
                return "MovedDetect[0]";
            }
            case "AlarmNet": {
                return "NetAlarm[0]";
            }
            case "VideoUnFocus": {
                return "UnFocusDetect[0]";
            }
        }
        return triggerName;
    }

    protected static boolean genericEventListContainsEvent(List<GenericEventDefinitionType> eventList, GenericEventDefinitionType event) {
        for (GenericEventDefinitionType genericEventDefinitionType : eventList) {
            String eventWithoutChannel = "";
            eventWithoutChannel = event.getEventType().contains("[") ? event.getEventType().substring(0, event.getEventType().indexOf("[")) : event.getEventType();
            if (!event.getEventType().equals(genericEventDefinitionType.getEventType()) && !eventWithoutChannel.equals(genericEventDefinitionType.getEventType()) || event.getSourceNumber() != genericEventDefinitionType.getSourceNumber()) continue;
            return true;
        }
        return false;
    }
}

