/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.device.video.dahua.DahuaEvent;
import de.seetec.v5.re.cm.device.video.dahua.DahuaEventClockIntf;
import java.util.ArrayList;
import java.util.ListIterator;

public class DahuaEventClock
implements Runnable {
    private volatile boolean isShutdown;
    private final DahuaEventClockIntf listener;
    private Thread thread;
    private final ArrayList<DahuaEvent> eventList = new ArrayList();

    public DahuaEventClock(DahuaEventClockIntf listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        while (!this.isShutdown()) {
            ListIterator<DahuaEvent> iterator = this.eventList.listIterator();
            while (iterator.hasNext()) {
                int channelID;
                DahuaEvent dahuaEvent = iterator.next();
                String channelName = dahuaEvent.getName();
                if (this.listener.isTriggerStarted(channelName, channelID = dahuaEvent.getChannel()) && this.listener.getStatus() == 0) {
                    this.listener.trigger(channelName, channelID);
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private boolean isShutdown() {
        return this.isShutdown;
    }

    protected void shutdown() {
        this.isShutdown = true;
    }

    protected void startTriggering() {
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.start();
    }

    protected void addEvent(DahuaEvent dahuaEvent) {
        this.eventList.add(dahuaEvent);
    }
}

