/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.dahua.DahuaAudioOutServer;
import de.seetec.v5.re.cm.device.video.dahua.DahuaCameraControl;
import de.seetec.v5.re.cm.device.video.dahua.DahuaCommand;
import de.seetec.v5.re.cm.device.video.dahua.DahuaDevice;
import de.seetec.v5.re.cm.device.video.dahua.DahuaHelper;
import de.seetec.v5.re.cm.device.video.dahua.DahuaTriggerHandler;
import de.seetec.v5.re.cm.device.video.dahua.DahuaVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class DahuaCameraSrv
extends LiveCameraSrv {
    private static final int MAXIMUM_TITLE_LENGTH = 31;
    private boolean isPal;
    private final Map<Integer, Integer> streams = new HashMap<Integer, Integer>();
    private DahuaHelper dahuaHelper;
    private DahuaDevice dahuaDevice;
    private final ReentrantLock reentrantLock = new ReentrantLock(false);

    public DahuaHelper getDahuaHelper() throws ConfigurationException {
        if (this.dahuaHelper == null) {
            this.dahuaHelper = this.dahuaDevice.getDahuaHelper();
        }
        return this.dahuaHelper;
    }

    @Override
    public int init(Vector<PresetCnf> presetList) throws ConfigurationException {
        int errorCode;
        this.dahuaDevice = (DahuaDevice)this.device;
        super.init(presetList);
        try {
            errorCode = this.setTitle(this.getVideoSourceCnf().useTitle(), this.getVideoSourceCnf().getTitle(), this.getVideoSourceCnf().getServerEntryNo() - 1);
            if (errorCode != 0) {
                this.logger.warn("Error while setting title on device " + this + " Error code: " + errorCode);
            }
            if ((errorCode = this.setDateTime(this.getVideoSourceCnf().isTimeDateEnabled(), this.getVideoSourceCnf().getServerEntryNo() - 1)) != 0) {
                this.logger.warn("Error while setting date/time display on device " + this + " Error code: " + errorCode);
            }
            if ((errorCode = this.setImageRotation(this.getVideoSourceCnf().getImageRotation() / 1000, this.getVideoSourceCnf().getServerEntryNo() - 1)) != 0) {
                this.logger.warn("Error while setting image rotation on device " + this + " Error code: " + errorCode);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting channel setting for " + this + ": " + ex.getMessage());
            errorCode = ex.getErrorCode();
        }
        return errorCode;
    }

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DahuaCameraControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        DahuaVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            videoSourceClient = new DahuaVideoSourceClient();
            videoSourceClient.setHttpHandler(this.dahuaDevice.getDahuaHelper().getHttpHandler());
            try {
                this.reentrantLock.lock();
                int errorCode = videoSourceClient.init(core, this, listener);
                if (errorCode != 0) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                    this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                    if (errorCode == HTTPStatusCode.HTTP_NOT_FOUND.getStatusCode()) {
                        throw new SeeTecException(-21656, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                    }
                    throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    public int getRotationAngleOnCamera(int channelID) throws SeeTecException, ConfigurationException {
        boolean mirrorOnCamera;
        String[] flip;
        int rotationCodeOnCamera = 0;
        String cameraConfiguration = this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/configManager.cgi?action=getConfig&name=VideoInOptions[" + channelID + "]");
        String[] rotationOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.VideoInOptions[" + channelID + "].Rotate90");
        if (rotationOnCamera.length == 1) {
            rotationCodeOnCamera = Integer.parseInt(rotationOnCamera[0].trim());
        }
        boolean flipOnCamera = (flip = DahuaHelper.getParameterValues(cameraConfiguration, "table.VideoInOptions[" + channelID + "].Flip")).length == 1 && flip[0].trim().toLowerCase().equals("true");
        String[] mirror = DahuaHelper.getParameterValues(cameraConfiguration, "table.VideoInOptions[" + channelID + "].Mirror");
        boolean bl = mirrorOnCamera = mirror.length == 1 && mirror[0].trim().toLowerCase().equals("true");
        if (flipOnCamera && mirrorOnCamera) {
            return 180;
        }
        if (!flipOnCamera && !mirrorOnCamera) {
            switch (rotationCodeOnCamera) {
                case 1: {
                    return 90;
                }
                case 2: {
                    return 270;
                }
                case 0: {
                    return 0;
                }
            }
        }
        return -1;
    }

    public void setRotationAngleOnCamera(int channelID, int rotationAngle) throws SeeTecException, ConfigurationException {
        boolean flip = false;
        boolean rotate = false;
        int rotationCode = 0;
        switch (rotationAngle) {
            case 90: {
                rotationCode = 1;
                break;
            }
            case 270: {
                rotationCode = 2;
                break;
            }
            case 180: {
                flip = true;
                rotate = true;
                break;
            }
        }
        String url = "/cgi-bin/configManager.cgi?action=setConfig&VideoInOptions[" + channelID + "].Rotate90=" + rotationCode + "&VideoInOptions[" + channelID + "].Mirror=" + (flip ? "true" : "false") + "&VideoInOptions[" + channelID + "].Flip=" + (rotate ? "true" : "false");
        try {
            this.getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (Exception ex) {
            this.logger.info("Image Rotation with command for VideoInOptions does not work. Trying command VideoImageControl for " + this);
        }
        url = "/cgi-bin/configManager.cgi?action=setConfig&VideoImageControl[" + channelID + "].Rotate90=" + rotationCode + "&VideoImageControl[" + channelID + "].Mirror=" + (flip ? "true" : "false") + "&VideoImageControl[" + channelID + "].Flip=" + (rotate ? "true" : "false");
        try {
            this.getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (Exception ex) {
            this.logger.info("Image Rotation with command for VideoImageControl does not work for " + this);
        }
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        this.logger.error("GetJpegSnapshot is not implemented");
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public boolean isIsPal() {
        return this.isPal;
    }

    public int getStreamNumber(int videoProfileID) {
        int streamNr = -1;
        if (this.streams.get(videoProfileID) != null) {
            streamNr = this.streams.get(videoProfileID);
        }
        return streamNr;
    }

    protected String[] subtract(String[] superset, String[] set) {
        ArrayList<String> resolutions = new ArrayList<String>();
        if (superset == null) {
            return set;
        }
        if (set == null) {
            return superset;
        }
        boolean foundDouble = false;
        for (String superSetElement : superset) {
            for (String setElement : set) {
                if (!superSetElement.equals(setElement)) continue;
                foundDouble = true;
            }
            if (!foundDouble) {
                resolutions.add(superSetElement);
            }
            foundDouble = false;
        }
        return resolutions.toArray(new String[resolutions.size()]);
    }

    @Override
    protected DahuaAudioOutServer createAudioOutServer() {
        NetworkParameter networkParameter = null;
        try {
            networkParameter = this.dahuaDevice.getDahuaNetworkParameter();
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Could not read Network parameter [" + configurationException.getMessage() + "] for " + this);
        }
        DahuaAudioOutServer dahuaAudioOutServer = new DahuaAudioOutServer(networkParameter);
        dahuaAudioOutServer.init();
        return dahuaAudioOutServer;
    }

    protected int setStreamMatching(int channelID, String resolution, String streamName, int videoProfileID) throws SeeTecException, ConfigurationException {
        this.isPal = this.dahuaDevice.isPal();
        int streamNumber = 0;
        if (this.dahuaDevice.getDeviceEntity().getEntityType() == 205603L) {
            switch (streamName.toLowerCase().trim()) {
                case "main stream": {
                    streamNumber = 0;
                    break;
                }
                case "sub stream 1": {
                    streamNumber = 1;
                    break;
                }
                case "extra stream 1": {
                    streamNumber = 1;
                    break;
                }
                default: {
                    streamNumber = 2;
                    break;
                }
            }
        } else {
            String[] resolutionsSubstream = this.getDahuaHelper().getCaps(DahuaCommand.CAPS, "caps[" + channelID + "].ExtraFormat[0].Video.ResolutionTypes", "caps.caps[" + channelID + "].ExtraFormat[0].Video.ResolutionTypes");
            String[] resolutionsMainstream = this.getDahuaHelper().getCaps(DahuaCommand.CAPS, "caps[" + channelID + "].MainFormat[0].Video.ResolutionTypes", "caps.caps[" + channelID + "].MainFormat[0].Video.ResolutionTypes", false);
            for (String resolutionMainstream : resolutionsMainstream = this.subtract(resolutionsMainstream, resolutionsSubstream)) {
                if (!resolutionMainstream.toLowerCase().equals(resolution) && !resolutionMainstream.toLowerCase().contains("1080")) continue;
                streamNumber = 0;
            }
            for (String resolutionSubstream : resolutionsSubstream) {
                if (!resolutionSubstream.toLowerCase().equals(resolution)) continue;
                streamNumber = 1;
            }
        }
        this.streams.put(videoProfileID, streamNumber);
        return 0;
    }

    private int setTitle(boolean useTitle, String title, int channelID) throws SeeTecException, ConfigurationException {
        String[] channelEnable = this.getDahuaHelper().getCaps(DahuaCommand.VIDEOWIDGET, "table.VideoWidget[" + channelID + "].ChannelTitle.EncodeBlend", "");
        if (!useTitle) {
            if (channelEnable.length != 1 || !channelEnable[0].equals("false")) {
                this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/configManager.cgi?action=setConfig&VideoWidget[" + channelID + "].ChannelTitle.EncodeBlend=false");
            }
        } else {
            String[] channelTitle = this.getDahuaHelper().getCaps(DahuaCommand.TITLE, "table.ChannelTitle[" + channelID + "].Name", "");
            if (channelTitle.length != 1 || !channelTitle[0].equals(title)) {
                String titleNameParam = title;
                if (titleNameParam.length() > 31) {
                    titleNameParam = titleNameParam.substring(0, 31);
                }
                this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/configManager.cgi?action=setConfig&ChannelTitle[" + channelID + "].Name=" + titleNameParam);
            }
            if (channelEnable.length != 1 || !channelEnable[0].equals("true")) {
                this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/configManager.cgi?action=setConfig&VideoWidget[" + channelID + "].ChannelTitle.EncodeBlend=true");
            }
        }
        return 0;
    }

    private int setDateTime(boolean useDateTime, int channelID) throws SeeTecException, ConfigurationException {
        String[] dateTimeEnable = this.getDahuaHelper().getCaps(DahuaCommand.VIDEOWIDGET, "table.VideoWidget[" + channelID + "].TimeTitle.EncodeBlend", "", false);
        if (useDateTime) {
            if (dateTimeEnable.length != 1 || !dateTimeEnable[0].equals("true")) {
                this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/configManager.cgi?action=setConfig&VideoWidget[" + channelID + "].TimeTitle.EncodeBlend=true");
            }
        } else if (dateTimeEnable.length != 1 || !dateTimeEnable[0].equals("false")) {
            this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/configManager.cgi?action=setConfig&VideoWidget[" + channelID + "].TimeTitle.EncodeBlend=false");
        }
        return 0;
    }

    private int setImageRotation(int rotationAngle, int channelID) throws SeeTecException, ConfigurationException {
        if ((this.getDevice().getDeviceDefinitionFromConfiguration().getImageRotationCapabilities().isCanRotateJPEGImage() || this.getDevice().getDeviceDefinitionFromConfiguration().getImageRotationCapabilities().isCanRotateMPEGImage()) && this.getRotationAngleOnCamera(channelID) != rotationAngle) {
            this.setRotationAngleOnCamera(channelID, rotationAngle);
        }
        return 0;
    }

    @Override
    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        DahuaTriggerHandler dahuaTriggerHandler = new DahuaTriggerHandler(this);
        return dahuaTriggerHandler;
    }

    @Override
    public int sendStatusService(int statusCode) {
        if (this.genericEventTriggerHandler instanceof DahuaTriggerHandler) {
            ((DahuaTriggerHandler)this.genericEventTriggerHandler).setStatus(statusCode);
        }
        return super.sendStatusService(statusCode);
    }
}

