/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.convision.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class ConvisionH264VideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.convision.mpeg.ConvisionH264VideoSourceClient";
    private static final String VIDEO_CHANNEL_NAME = "video";
    private boolean isPal = true;
    private int resolution = -1;
    private double iFrameDistance = -1.0;
    private int framerate = -1;

    @Override
    public int init() {
        byte[] result = null;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.networkParameter.setSoTimeout(5000);
        StringBuilder sb = new StringBuilder(256);
        sb.append("/httpapi");
        sb.append("/ReadParam?action=readparam&VID_INPUTFORMAT=0");
        try {
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE, (boolean)true);
            if (result != null) {
                if (new String(result).indexOf("VID_INPUTFORMAT=257") != -1) {
                    this.isPal = false;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("Camera is set to NTSC ");
                    }
                } else {
                    this.isPal = true;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("Camera is set to PAL ");
                    }
                }
            }
        }
        catch (SeeTecException see) {
            this.logger.error((Object)see, (Throwable)see);
            this.errorCode = see.getErrorCode();
            return this.errorCode;
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        long entityType = this.getVideoSrv().getEntityType();
        long deviceType = this.getVideoSrv().getDevice().getDeviceType();
        if (entityType == 212700L || entityType == 212800L || entityType == 212701L || entityType == 212801L || entityType == 212702L || entityType == 212802L || entityType == 212703L || entityType == 212803L) {
            sb = new StringBuilder("/httpapi/WriteParam?action=writeparam&page=video");
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Setting Resolution for entity " + entityType);
            }
            this.resolution = this.isPal ? (this.width == 720 ? (this.height == 576 ? 0 : 1) : (this.width == 352 ? (this.height == 576 ? 2 : 3) : 18)) : (this.width == 720 ? (this.height == 480 ? 0 : 1) : (this.width == 352 ? (this.height == 480 ? 2 : 3) : 18));
        } else if (entityType == 219900L || entityType == 219901L) {
            sb = new StringBuilder("/httpapi/WriteParam?action=writeparam&channel=" + this.videoSourceNr);
            this.resolution = this.isPal ? (this.width == 720 ? (this.height == 576 ? 4 : 5) : (this.height == 576 ? 6 : 7)) : (this.width == 720 ? (this.height == 576 ? 0 : 1) : (this.height == 576 ? 2 : 3));
        } else {
            sb = new StringBuilder("/httpapi/WriteParam?action=writeparam&page=video");
            if (this.width == 352) {
                this.resolution = this.height == 240 ? 3 : (this.height == 288 ? 7 : (this.height == 480 ? 2 : 6));
            } else if (this.width == 640) {
                if (this.height == 480) {
                    this.resolution = 8;
                }
            } else if (this.width == 720) {
                if (this.height == 240) {
                    this.resolution = 1;
                } else if (this.height == 288) {
                    this.resolution = 5;
                } else if (this.height == 480) {
                    this.resolution = 0;
                } else if (this.height == 576) {
                    this.resolution = 4;
                }
            } else if (this.width == 800) {
                if (this.height == 600) {
                    this.resolution = 9;
                }
            } else if (this.width == 1024) {
                if (this.height == 768) {
                    this.resolution = 10;
                }
            } else if (this.width == 1280) {
                if (this.height == 720) {
                    this.resolution = 16;
                } else if (this.height == 960) {
                    this.resolution = 11;
                } else if (this.height == 1024) {
                    this.resolution = 12;
                }
            } else if (this.width == 1440) {
                if (this.height == 900) {
                    this.resolution = 13;
                }
            } else if (this.width == 1600) {
                if (this.height == 900) {
                    this.resolution = 14;
                }
            } else if (this.width == 1680) {
                if (this.height == 1050) {
                    this.resolution = 15;
                }
            } else if (this.width == 1920) {
                if (this.height == 1080) {
                    this.resolution = 17;
                }
            } else {
                this.resolution = 18;
            }
        }
        this.framerate = entityType == 212705L || entityType == 212805L ? (this.isPal ? (this.fps > 22500L ? 0 : (this.fps > 18000L ? 1 : (this.fps > 14000L ? 2 : (this.fps > 11000L ? 3 : (this.fps > 9000L ? 4 : (this.fps > 7000L ? 5 : (this.fps > 5500L ? 6 : (this.fps > 4500L ? 7 : (this.fps > 3500L ? 8 : (this.fps > 2500L ? 9 : (this.fps > 1500L ? 10 : 11))))))))))) : (this.fps > 27500L ? 0 : (this.fps > 22500L ? 1 : (this.fps > 17500L ? 2 : (this.fps > 12500L ? 3 : (this.fps > 9000L ? 4 : (this.fps > 7000L ? 5 : (this.fps > 5500L ? 6 : (this.fps > 4500L ? 7 : (this.fps > 3500L ? 8 : (this.fps > 2500L ? 9 : (this.fps > 1500L ? 10 : 11)))))))))))) : (deviceType == 201111L || deviceType == 202702L ? (this.fps > 27500L ? 0 : (this.fps > 22500L ? 1 : (this.fps > 17500L ? 2 : (this.fps > 12500L ? 3 : (this.fps > 9000L ? 4 : (this.fps > 7000L ? 5 : (this.fps > 5500L ? 6 : (this.fps > 4500L ? 7 : (this.fps > 3500L ? 8 : (this.fps > 2500L ? 9 : (this.fps > 1500L ? 10 : 11))))))))))) : (this.isPal ? (this.fps > 22500L ? 0 : (this.fps > 18000L ? 1 : (this.fps > 14000L ? 2 : (this.fps > 11000L ? 3 : (this.fps > 9000L ? 4 : (this.fps > 7000L ? 5 : (this.fps > 5500L ? 6 : (this.fps > 4500L ? 7 : (this.fps > 3500L ? 8 : (this.fps > 2500L ? 9 : (this.fps > 1500L ? 10 : (this.fps > 800L ? 11 : (this.fps > 500L ? 12 : (this.fps > 300L ? 13 : 14)))))))))))))) : (this.fps > 27500L ? 0 : (this.fps > 22500L ? 1 : (this.fps > 17500L ? 2 : (this.fps > 12500L ? 3 : (this.fps > 9000L ? 4 : (this.fps > 7000L ? 5 : (this.fps > 5500L ? 6 : (this.fps > 4500L ? 7 : (this.fps > 3500L ? 8 : (this.fps > 2500L ? 9 : (this.fps > 1500L ? 10 : (this.fps > 800L ? 11 : (this.fps > 500L ? 12 : (this.fps > 300L ? 13 : 14))))))))))))))));
        sb.append("&VID_SCALEENABLE=1");
        sb.append("&VID_RESOLUTION=");
        sb.append(this.resolution);
        sb.append("&VID_FRAMERATE=");
        sb.append(this.framerate);
        if (this.isConstantBitrateUsed) {
            this.bandwidth /= 1024;
            this.bandwidth = entityType == 212705L || entityType == 212805L || entityType == 212704L || entityType == 212804L || this.getVideoSrv().getDevice().getDeviceType() == 201110L || this.getVideoSrv().getDevice().getDeviceType() == 202701L ? (this.bandwidth > 8000 ? 8000 : this.bandwidth) : (this.getVideoSrv().getDevice().getDeviceType() == 201111L || this.getVideoSrv().getDevice().getDeviceType() == 202702L ? (this.bandwidth > 2000 ? 2000 : this.bandwidth) : (this.bandwidth > 4000 ? 4000 : this.bandwidth));
            sb.append("&VID_PREFERENCE=1");
            sb.append("&VID_BANDWIDTH=");
            sb.append(this.bandwidth);
        } else {
            this.quality = 100000 - this.quality;
            this.quality /= 14285;
            this.quality = this.quality > 7 ? 7 : this.quality;
            sb.append("&VID_PREFERENCE=0");
            sb.append("&VID_QUALITY=");
            sb.append(this.quality);
        }
        sb.append("&VID_IINTERVAL=");
        this.iFrameDistance = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 1, 255);
        sb.append((int)this.iFrameDistance);
        sb.append("&VID_FRAMEENCODE=1");
        if (this.useDateTime) {
            sb.append("&VID_BURNINTIME=1");
        } else {
            sb.append("&VID_BURNINTIME=0");
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("URL for setting the parameters is: " + sb.toString());
            }
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MIN_VALUE, (boolean)true);
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/httpapi/WriteParam?action=writeparam&EVT_RELAYDURATION_1=0", (int)Integer.MIN_VALUE, (boolean)true);
            if (result == null) {
                this.logger.error("Error setting alarm output configuration");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Response: " + new String(result));
            }
        }
        catch (SeeTecException see) {
            this.logger.error((Object)see, (Throwable)see);
            this.errorCode = see.getErrorCode();
            return this.errorCode;
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        try {
            sb = new StringBuilder("/httpapi/WriteParam?action=writeparam&page=network&NET_RTSPPORT=");
            sb.append(this.listener.getVideoSourceParameter().getRtspPort());
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MIN_VALUE, (boolean)true);
            if (result == null) {
                this.logger.error("Error setting camera configuration");
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception occured while setting RTSP Port on camera: " + ex);
        }
        if (this.isAudioEnabled) {
            this.logger.info("Audio Parameter: " + this.audioCodec + " with " + this.audioBitrate + "bit for " + this.getVideoSrv().getDevice());
            String audioURL = "/httpapi/WriteParam?action=writeparam&AUD_AUDIOMODE=3";
            try {
                result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)audioURL, (int)Integer.MIN_VALUE, (boolean)true);
                if (result == null) {
                    this.logger.error("Error enabling Audio on Camera ");
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception occured enabling Audio on Camera: " + (Object)((Object)ex));
                return ex.getErrorCode();
            }
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException audioURL) {
            // empty catch block
        }
        this.rtspUrl = "rtsp://" + this.getHost() + "/" + VIDEO_CHANNEL_NAME + this.videoSourceNr + (this.isAudioEnabled ? "+audio1" : "");
        this.rtspSettings = new RTSPStreamSettings();
        int[] resolutionForTest = new int[]{this.width, this.height};
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, "*");
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.rtspSettings.setCheckResolution(true, resolutionForTest);
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while creating RTSP Handler for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("RTSPHandler.init failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    public int unsignedBytesToInt(byte first, byte second) {
        int i = 0;
        i |= first & 0xFF;
        i <<= 8;
        return i |= second & 0xFF;
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

