/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.convision;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.HttpPersistentConnectionHandler;
import de.seetec.v5.re.cm.device.shared.net.HttpPersistentConnectionListenerIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;

public class ConvisionMotionDetectionHandler
extends MotionDetectionHandler
implements Runnable,
HttpPersistentConnectionListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.convision.ConvisionMotionDetectionHandler";
    private Thread myThread = null;
    private NetworkParameter networkParameter = null;
    private HttpPersistentConnectionHandler httpPersistentConnectionHandler = null;

    public ConvisionMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.networkParameter.setSoTimeout(5000);
            String request = "/httpapi/ReadParam?action=readpage&page=video";
            byte[] response = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)request, (int)Integer.MAX_VALUE, (boolean)true);
            if (!new String(response).contains("VID_MOTIONENABLE=1")) {
                this.logger.warn("Motion Detection on camera DISABLED for " + this.listener.getVideoSrv());
                this.logger.warn("Trying to enable Motion Detection...");
                request = "/httpapi/WriteParam?action=writeparam&VID_MOTIONENABLE=1";
                byte[] response2 = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)request, (int)Integer.MIN_VALUE);
                if (response2 == null || new String(response).indexOf("ok") == -1) {
                    this.logger.warn("Could not enable Motion Detection on camera. Enable it on the camera or disable motion detection windows in SeeTec 5 system.");
                    return -21664;
                }
            }
        }
        catch (SeeTecException e) {
            this.listener.getVideoSrv().sendStatusService(e.getErrorCode());
            this.logger.error("Error while doing MD test request for " + this.listener.getVideoSrv());
            return e.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error("Error while doing MD test request for " + this.listener.getVideoSrv(), (Throwable)e);
            return -20001;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpPersistentConnectionHandler != null) {
            this.httpPersistentConnectionHandler.shutdown();
            this.httpPersistentConnectionHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public void run() {
        int TIME_FOR_ITERATION = 500;
        int channelNumber = 0;
        try {
            channelNumber = this.listener.getVideoSrv().getVideoSourceCnf().getServerEntryNo();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        String motionDetectionURL = "/httpapi/GetState?action=getinput&GIS_MOTION" + channelNumber + "=0";
        this.httpPersistentConnectionHandler = new HttpPersistentConnectionHandler();
        this.httpPersistentConnectionHandler.init(this, this.networkParameter, motionDetectionURL, 500);
        int errorCode = this.httpPersistentConnectionHandler.startPersistentConnection(true);
        if (errorCode != 0) {
            this.logger.error("Error while reading HTTP persistent connection data for " + this + ", Errorcode: " + errorCode);
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.video.convision.ConvisionMotionDetectionHandler@" + Integer.toHexString(this.hashCode());
        return "[ " + sThis.substring(sThis.lastIndexOf(46) + 1) + ", [ " + (this.listener == null ? "" : this.listener.getVideoSrv()) + " ] ]";
    }

    @Override
    public void deliverContent(byte[] httpPersistentConnectionContent) {
        String[] linesOfDetectionData = new String(httpPersistentConnectionContent).split("\r\n");
        for (int i = 0; i < linesOfDetectionData.length; ++i) {
            boolean hasDetected;
            if (!linesOfDetectionData[i].contains("GIS_MOTION")) continue;
            if (linesOfDetectionData[i].contains("=1")) {
                hasDetected = true;
            } else {
                if (!linesOfDetectionData[i].contains("=0")) continue;
                hasDetected = false;
            }
            if (!hasDetected) break;
            hasDetected = false;
            this.listener.evaluateWindow(0);
            break;
        }
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (statusCode != 0) {
            this.logger.error("Error while retrieving Motion Detection data over HTTP for " + this);
            this.listener.notifyForNetworkProblems();
        }
    }
}

