/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.convision;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.convision.ConvisionDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class ConvisionIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.convision.ConvisionIOHandler";
    private ConvisionDevice convisionDevice = null;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.checkDigitalInputs();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    protected final void checkDigitalInputs() {
        int errorCode = 0;
        int[] inputValues = new int[super.getHighestInputNumber()];
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Checking [" + inputValues.length + "] inputs ...");
        }
        if ((errorCode = this.readDigitalInputs(inputValues)) != 0) {
            this.logger.warn("Reading inputs failed with error [" + errorCode + "] :-(");
            return;
        }
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        for (int i = 0; i < iServices.length; ++i) {
            iServices[i].checkInput(inputValues);
        }
    }

    private int readDigitalInputs(int[] nInputs) {
        int errorCode = 0;
        try {
            for (int i = 1; i <= nInputs.length; ++i) {
                errorCode = this.readDigitalInput(nInputs, i);
                if (errorCode == 0) continue;
                this.logger.error("Reading digital input [" + i + "] failed for " + this + " :-(");
                return errorCode;
            }
            return 0;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot read inputs from [" + this.host + ":" + this.port + "]");
        }
    }

    private int readDigitalInput(int[] nInputs, int nInputNumber) {
        this.convisionDevice = (ConvisionDevice)this.device;
        int entityID = this.convisionDevice.getDeviceEntity().getEntityType().intValue();
        if ((long)entityID == 201109L || (long)entityID == 201112L || (long)entityID == 201113L || (long)entityID == 201114L || (long)entityID == 201115L || (long)entityID == 201116L || (long)entityID == 201110L || (long)entityID == 201111L || (long)entityID == 219900L || (long)entityID == 219901L || (long)entityID >= 212800L && (long)entityID <= 212899L) {
            String sURL = "/httpapi/GetState?action=getinput&GIS_SENSOR" + nInputNumber + "=0";
            try {
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sURL, (int)Integer.MAX_VALUE, (boolean)true);
                String resultString = new String(result);
                if (resultString.toLowerCase().indexOf("gis_sensor" + nInputNumber + "=1") >= 0) {
                    nInputs[nInputNumber - 1] = 1;
                } else if (resultString.toLowerCase().indexOf("gis_sensor" + nInputNumber + "=0") >= 0) {
                    nInputs[nInputNumber - 1] = 0;
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while reading digital inputs for " + this + " : " + ex.getMessage());
            }
            return 0;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Reading input [" + nInputNumber + "] ...");
        }
        String url = "/output/dioswitch?getstate=" + nInputNumber;
        try {
            String result = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE));
            String[] outputStrings = result.toLowerCase().split("outputs");
            if (outputStrings.length == 2) {
                nInputs[nInputNumber - 1] = outputStrings[1].indexOf("on") != -1 ? 1 : 0;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading Inputs for " + this + ": " + ex.getMessage());
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int nOutputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(nOutputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + nOutputNumber + "] :-(");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + nOutputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            String url = "";
            this.convisionDevice = (ConvisionDevice)this.device;
            int entityID = this.convisionDevice.getDeviceEntity().getEntityType().intValue();
            if ((long)entityID == 201109L || (long)entityID == 201112L || (long)entityID == 201113L || (long)entityID == 201114L || (long)entityID == 201115L || (long)entityID == 201116L || (long)entityID == 201110L || (long)entityID == 201111L || (long)entityID == 219900L || (long)entityID == 219901L || (long)entityID >= 212800L && (long)entityID <= 212899L) {
                url = "/httpapi/SetState?action=setoutput&OUT_ALARM" + nOutputNumber + "=" + value;
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            } else {
                url = "/output/dioswitch?rl" + nOutputNumber;
                url = value > 0 ? url + "=on" : url + "=off";
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            }
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nOutputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot write value [" + value + "] to output [" + nOutputNumber + "] :-(");
        }
    }
}

