/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.convision;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.convision.ConvisionCameraControl;
import de.seetec.v5.re.cm.device.video.convision.jpeg.ConvisionJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.convision.mpeg.ConvisionH264VideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.SeeTecException;

public class ConvisionCameraSrv
extends LiveCameraSrv {
    private final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.convision.ConvisionCameraSrv";

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new ConvisionCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        VideoSourceClient videoSourceClient = null;
        long entityType = super.getEntityType();
        try {
            int errorCode;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("StreamingMode for " + this + " is [" + this.getVideoSourceCnf().getMediaCodec() + "]");
            }
            if (listener.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                if (entityType == 212700L || entityType == 212701L || entityType == 212702L || entityType == 212703L || entityType == 212704L || entityType == 212705L || entityType == 201110L || entityType == 201111L || entityType == 219900L || entityType == 219901L || entityType >= 212800L && entityType <= 212899L) {
                    videoSourceClient = new ConvisionH264VideoSourceClient();
                }
            } else {
                videoSourceClient = new ConvisionJPEGVideoSourceClient();
            }
            if ((errorCode = videoSourceClient.init(core, this, listener)) != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }
}

