/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.cbc;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;

public class CBCIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.cbc.CBCIOHandler";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
    }

    public void processContent(byte[] status) {
        int[] nInputValues = new int[super.getHighestInputNumber()];
        nInputValues[status[0]] = status[1];
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        for (int i = 0; i < iServices.length; ++i) {
            iServices[i].checkInput(nInputValues);
        }
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        int errorCode = 0;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] :-(");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            String url = "/SetGPIO.cgi?Out" + outputNumber + "STA=" + value;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot write value [" + value + "] to output [" + outputNumber + "] :-(");
        }
    }
}

