/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.canon2;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessage;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.video.canon2.Canon2Device;
import de.seetec.v5.re.cm.device.video.canon2.Canon2IoHandler;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Canon2EventHandler
extends Basic
implements Runnable {
    private Logger logger = null;
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.canon2.Canon2EventHandler";
    private Thread thread = null;
    private OnvifCore onvifCore = null;
    private final Collection<HardwareMotionDetection<? extends MotionDetectionHandler>> hardwareMotionDetections = Collections.synchronizedList(new ArrayList());
    private Canon2IoHandler canon2IoHandler = null;

    public Canon2EventHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    public int init(OnvifCore onvifCore, Canon2Device canon2Device) {
        this.onvifCore = onvifCore;
        this.thread = new Thread((Runnable)this, CLASS_NAME);
        this.thread.start();
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int tryCounter = 0;
        while (!this.isShutdown(CLASS_NAME)) {
            try {
                List<EventMessage> eventMessages;
                if (tryCounter == 10) {
                    Thread.sleep(59500L);
                    tryCounter = 0;
                } else {
                    Thread.sleep(50L);
                }
                try {
                    eventMessages = this.onvifCore.getEventService().pullMessages(OnvifHelper.intToDuration(5), 30);
                    tryCounter = 0;
                }
                catch (Exception e) {
                    ++tryCounter;
                    this.logger.warn("Error while evaluating Onvif event for " + this, (Throwable)e);
                    continue;
                }
                HashMap<Integer, Boolean> inputs = new HashMap<Integer, Boolean>();
                for (EventMessage eventMessage : eventMessages) {
                    DigitalInputSrv[] iServices;
                    if (this.canon2IoHandler == null || (iServices = this.canon2IoHandler.getDigitalInputSrv()) == null) continue;
                    for (int i = 0; i < iServices.length; i += 2) {
                        if (!iServices[i + 1].getDigitalInputSrvCnf().isEnabled()) continue;
                        String onvifEventType = "Device/Trigger/DigitalInput";
                        String topic = this.removeNamespace(eventMessage.getTopic());
                        if (!topic.contains("Device/Trigger/DigitalInput") || !eventMessage.getDataName().equals("LogicalState")) continue;
                        int input = Integer.parseInt(eventMessage.getSourceValue().substring(5));
                        if (iServices[i + 1].getInputNumber() != input) continue;
                        boolean inputDetected = eventMessage.getDataValue().equals("true");
                        if (inputs.get(input) != null && ((Boolean)inputs.get(input)).booleanValue()) continue;
                        inputs.put(input - 1, inputDetected);
                    }
                }
                for (Map.Entry entry : inputs.entrySet()) {
                    this.canon2IoHandler.receiveAlarm((Integer)entry.getKey(), (Boolean)entry.getValue() != false ? 1 : 0);
                }
            }
            catch (Exception exception) {
                this.logger.warn("Error while evaluating Onvif event for " + this, (Throwable)exception);
            }
        }
        super.setRunFinished(CLASS_NAME, true);
    }

    public int shutdown() {
        this.startShutdown(CLASS_NAME);
        return 0;
    }

    public void activateMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        if (!this.hardwareMotionDetections.contains(hardwareMotionDetection) && hardwareMotionDetection != null) {
            this.hardwareMotionDetections.add(hardwareMotionDetection);
        }
    }

    public void deactivateMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        if (this.hardwareMotionDetections.contains(hardwareMotionDetection)) {
            this.hardwareMotionDetections.remove(hardwareMotionDetection);
        }
    }

    public void activateInputAlarms(Canon2IoHandler canon2IoHandler) {
        this.canon2IoHandler = canon2IoHandler;
    }

    public void deactivateInputAlarms() {
        this.canon2IoHandler = null;
    }

    protected String removeNamespace(String inputString) {
        if (inputString == null) {
            return null;
        }
        String[] stringWithoutSlashes = inputString.split("/");
        if (stringWithoutSlashes.length < 2) {
            return inputString;
        }
        for (int i = 0; i < stringWithoutSlashes.length; ++i) {
            String[] stringWithoutColon;
            String stringBetweenSlashes = stringWithoutSlashes[i];
            if (!stringBetweenSlashes.contains(":") || (stringWithoutColon = stringBetweenSlashes.split(":")).length != 2) continue;
            stringWithoutSlashes[i] = stringWithoutColon[1];
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < stringWithoutSlashes.length; ++i) {
            result.append(stringWithoutSlashes[i]);
            if (i >= stringWithoutSlashes.length - 1) continue;
            result.append("/");
        }
        return result.toString();
    }
}

