/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.canon2;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.services.PtzService;
import de.seetec.v5.re.cm.device.video.canon2.Canon2Device;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.PTZConfiguration;
import org.onvif.ver10.schema.PTZPreset;
import org.onvif.ver10.schema.Profile;
import org.xml.sax.SAXException;

public class Canon2CameraControl
extends CameraControl {
    private PtzService ptzService = null;
    private String profileName = null;

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        if (this.ptzService == null) {
            try {
                Canon2Device onvifDevice = (Canon2Device)videoSrv.getDevice();
                OnvifCore onvifCore = onvifDevice.getOnvifCore();
                this.ptzService = onvifCore.getPtzService();
                Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
                int videoSourceNumber = 0;
                try {
                    videoSourceNumber = videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                }
                catch (ConfigurationException exception) {
                    this.logger.warn("Error while initializing ONVIF PTZ configuration, could not read VideoSourceNumber from configuration", (Throwable)exception);
                }
                this.profileName = onvifCore.getMediaService().getSeeTecProfile(videoSourceNumber, 0).getToken();
                Profile profile = onvifCore.getMediaService().getOnvifMediaService().getProfile(this.profileName);
                if (profile.getPTZConfiguration() == null) {
                    String ptzConfigurationToken;
                    List ptzConfigurations = onvifCore.getPtzService().getOnvifPtzService().getConfigurations();
                    if (videoSourceNumber < ptzConfigurations.size()) {
                        ptzConfigurationToken = ((PTZConfiguration)ptzConfigurations.get(videoSourceNumber)).getToken();
                    } else {
                        ptzConfigurationToken = ((PTZConfiguration)ptzConfigurations.get(0)).getToken();
                        this.logger.warn("Error while initializing ONVIF PTZ configuration, not enough PTZ configurations available, use first one instead");
                    }
                    mediaService.addPTZConfiguration(profile.getToken(), ptzConfigurationToken);
                }
            }
            catch (SeeTecException exception) {
                this.logger.warn("Error while initializing ONVIF PTZ configuration", (Throwable)exception);
                return exception.getErrorCode();
            }
        }
        return super.init(videoSrv, api, host, port, usr, pwd, presetList);
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        try {
            this.ptzService.sendContinuousPtzCommand(this.profileName, panSpeed, tiltSpeed, zoomSpeed, 10, 100L);
            this.videoSrv.notifyForCameraControl();
            return 0;
        }
        catch (SeeTecException exception) {
            this.logger.error((Object)exception);
            return exception.getErrorCode();
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
            return -21653;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer focusSpeed) {
        try {
            if (focusSpeed == null) {
                return 0;
            }
            String sessionId = this.getSessionId();
            this.openSession(sessionId);
            String urlRequest = "/-wvhttp-01-/control.cgi?s=" + sessionId.trim() + "&c.1.focus=";
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)(urlRequest.trim() + "manual"), (int)Integer.MAX_VALUE);
            if (focusSpeed >= 0) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)(urlRequest.trim() + "near"), (int)Integer.MAX_VALUE);
            } else {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)(urlRequest.trim() + "far"), (int)Integer.MAX_VALUE);
            }
            this.closeSession(sessionId);
        }
        catch (SAXException ex) {
            LogManager.getLogger((String)Canon2CameraControl.class.getName()).log(Level.ERROR, ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            LogManager.getLogger((String)Canon2CameraControl.class.getName()).log(Level.ERROR, ex.getMessage(), (Throwable)ex);
        }
        catch (SeeTecException ex) {
            LogManager.getLogger((String)Canon2CameraControl.class.getName()).log(Level.ERROR, ex.getMessage(), (Throwable)ex);
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        try {
            String sessionId = this.getSessionId();
            this.openSession(sessionId);
            String urlRequest = "/-wvhttp-01-/control.cgi?s=" + sessionId.trim() + "&c.1.focus=auto";
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlRequest.trim(), (int)Integer.MAX_VALUE);
            this.closeSession(sessionId);
        }
        catch (SAXException ex) {
            LogManager.getLogger((String)Canon2CameraControl.class.getName()).log(Level.ERROR, ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            LogManager.getLogger((String)Canon2CameraControl.class.getName()).log(Level.ERROR, ex.getMessage(), (Throwable)ex);
        }
        catch (SeeTecException ex) {
            LogManager.getLogger((String)Canon2CameraControl.class.getName()).log(Level.ERROR, ex.getMessage(), (Throwable)ex);
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setHomePosition() {
        try {
            this.ptzService.getOnvifPtzService().gotoHomePosition(this.profileName, null);
            this.videoSrv.notifyForCameraControl();
            return 0;
        }
        catch (Exception exception) {
            this.logger.warn("Setting HomePosition failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() != null && !preset.getName().equals(encodedPresetName)) continue;
                this.ptzService.getOnvifPtzService().removePreset(this.profileName, preset.getToken());
            }
            Holder presetToken = new Holder();
            this.ptzService.getOnvifPtzService().setPreset(this.profileName, encodedPresetName, presetToken);
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, (String)presetToken.value, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() == null || !preset.getName().equals(encodedPresetName)) continue;
                this.ptzService.getOnvifPtzService().gotoPreset(this.profileName, preset.getToken(), null);
                this.videoSrv.notifyForCameraControl();
                break;
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.warn("Going to preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() != null && !preset.getName().equals(encodedPresetName)) continue;
                this.ptzService.getOnvifPtzService().removePreset(this.profileName, preset.getToken());
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Removing preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }

    private String getSessionId() throws SAXException, JAXBException, SeeTecException {
        String sessionId = "";
        String urlRequest = "/-wvhttp-01-/open.cgi?s.priority=5";
        byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlRequest, (int)Integer.MAX_VALUE);
        String responseFromCamera = new String(result);
        sessionId = responseFromCamera.substring(responseFromCamera.indexOf("s:=") + 3, responseFromCamera.indexOf("s.origin:=")).trim();
        return sessionId;
    }

    private void openSession(String sessionID) throws SeeTecException {
        String urlRequest = "/-wvhttp-01-/claim.cgi?s=" + sessionID.trim();
        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlRequest, (int)Integer.MAX_VALUE);
    }

    private void closeSession(String sessionID) throws SeeTecException {
        String urlRequest = "/-wvhttp-01-/yield.cgi?s=" + sessionID.trim();
        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlRequest, (int)Integer.MAX_VALUE);
    }
}

