/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.canon;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.canon.CanonCameraControl;
import de.seetec.v5.re.cm.device.video.canon.CanonDevice;
import de.seetec.v5.re.cm.device.video.canon.CanonVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.SeeTecException;

public final class CanonCameraSrv
extends LiveCameraSrv {
    public static final String PROFILE_1 = "profile1";
    public static final String PROFILE_2 = "profile0";
    public static final String VIDEO_SOURCE_1 = "0";
    public static final String VIDEO_ENCODER_1 = "264";
    public static final String VIDEO_ENCODER_2 = "1";
    public static final String AUDIO_SOURCE_1 = "0";
    public static final String AUDIO_ENCODER_1 = "0";
    public static final String PTZ_CONFIGURATION_1 = "0";
    public static final String PTZ_NODE_1 = "0";

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new CanonCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        CanonVideoSourceClient videoSourceClient = null;
        try {
            CanonDevice canonDevice;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("StreamingMode for " + this + " is [" + this.getVideoSourceCnf().getMediaCodec() + "]");
            }
            if ((canonDevice = (CanonDevice)this.getDevice()).isOnvifDevice()) {
                videoSourceClient = new CanonVideoSourceClient();
            }
            if ((errorCode = videoSourceClient.init(core, this, listener)) != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }
}

