/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.util.SeeTecException;

public class VideoOperationModeXML
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpXml.VideoOperationModeXML";
    private int value = -1;

    public void setMode(int mode) {
        this.value = mode;
    }

    public int getMode() {
        return this.value;
    }

    public VideoOperationModeXML() {
        this.command = Command.CMD_VIDEO_OPERATION_MODE;
        this.type = Type.TYPE_T_DWORD;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            if (this.value == -1) {
                throw new SeeTecException(-20037, "Operation Mode " + this.value + " not valid for " + this);
            }
            this.setPayload(Integer.toString(this.value));
        }
        super.send(device, direction);
        this.value = this.getResultAsInt();
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("Video Codec: ");
        switch (this.value) {
            case 0: {
                res.append("H.263");
                break;
            }
            case 1: {
                res.append("H.264");
                break;
            }
            case 2: {
                res.append("H.265");
                break;
            }
            default: {
                res.append("unknown");
            }
        }
        return super.toString() + "\r\n" + res.toString();
    }
}

