/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.VideoInputFormat;
import java.util.ArrayList;
import java.util.List;

public class VideoInputFormatExVerboseXML
extends PacketXML {
    private final List<VideoInputFormat> inputFormats = new ArrayList<VideoInputFormat>();

    public VideoInputFormatExVerboseXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_CONF_VIDEO_INPUT_FORMAT_EX_VERBOSE;
    }

    public int getFramerateCorridorMode(int width, int height) {
        for (VideoInputFormat videoInputFormat : this.inputFormats) {
            if (this.isUprightImage(width, height) != this.isUprightImage(videoInputFormat.getWidth(), videoInputFormat.getHeight()) || !videoInputFormat.isRotate90() || !videoInputFormat.isRotate270()) continue;
            return videoInputFormat.getMaxMilliFps();
        }
        return -1;
    }

    public boolean isRotation90() {
        for (VideoInputFormat videoInputFormat : this.inputFormats) {
            if (!videoInputFormat.isRotate90()) continue;
            return true;
        }
        return false;
    }

    public boolean isRotation180() {
        for (VideoInputFormat videoInputFormat : this.inputFormats) {
            if (!videoInputFormat.isRotate180()) continue;
            return true;
        }
        return false;
    }

    public boolean isRotation270() {
        for (VideoInputFormat videoInputFormat : this.inputFormats) {
            if (!videoInputFormat.isRotate270()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        super.send(device, direction);
        byte[] input = this.getResultAsByteArray();
        if (input != null && input.length >= 20) {
            for (int offset = 0; offset < input.length && input.length - offset >= 20; offset += 20) {
                byte[] inputData = new byte[20];
                System.arraycopy(input, offset, inputData, 0, inputData.length);
                VideoInputFormat inputFormat = new VideoInputFormat(inputData);
                this.inputFormats.add(inputFormat);
            }
        }
    }

    public int getIdCorridorMode(int width, int height) {
        for (VideoInputFormat videoInputFormat : this.inputFormats) {
            if (!videoInputFormat.isRotate90() || !videoInputFormat.isRotate270() || this.isUprightImage(width, height) != this.isUprightImage(videoInputFormat.getWidth(), videoInputFormat.getHeight())) continue;
            return videoInputFormat.getId();
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder("Input Formats:");
        for (VideoInputFormat input : this.inputFormats) {
            if (input == null) continue;
            ret.append("\r\n\tWidth: ").append(input.getWidth());
            ret.append("\r\n\tHeight: ").append(input.getHeight());
            ret.append("\r\n\tRotation 90\u00c2\u00b0: ").append(input.isRotate90());
            ret.append("\r\n\tRotation 180\u00c2\u00b0: ").append(input.isRotate180());
            ret.append("\r\n\tRotation 270\u00c2\u00b0: ").append(input.isRotate270());
            ret.append("\r\n\tMax Framerate: ").append(input.getMaxMilliFps());
        }
        return super.toString() + "\r\n" + ret.toString();
    }

    private boolean isUprightImage(int width, int height) {
        return width < height;
    }
}

