/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Stamping;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.util.SeeTecException;

public class StampXML
extends PacketXML
implements Stamping {
    private int value = -1;
    private String stampName;
    private String INVALID_VALUES_ERROR = "%s of %d not valid for %s";

    public StampXML(Command command, String stampName) {
        this.command = command;
        this.type = Type.TYPE_T_OCTET;
        this.stampName = stampName;
    }

    @Override
    public void setStamp(int value) {
        this.value = value;
    }

    @Override
    public int getStamp() {
        return this.value;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            if (this.value == -1) {
                throw new SeeTecException(-20037, String.format(this.INVALID_VALUES_ERROR, this.stampName, this.value, this));
            }
            this.payload = Integer.toString(this.value);
        }
        super.send(device, direction);
        this.value = this.getResultAsInt();
    }
}

