/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;

public class SoftwareVersionXML
extends PacketXML {
    private String major = "";
    private String minor = "";
    private String build = "";

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getBuild() {
        return this.build;
    }

    public SoftwareVersionXML() {
        this.type = Type.TYPE_P_STRING;
        this.command = Command.CMD_SOFTWARE_VERSION;
    }

    public String getFirmware() {
        return this.major + "." + this.minor + "." + this.build;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Firmware Version is not allowed");
        }
        super.send(device, direction);
        String input = this.getResultAsString();
        if (input != null && input.length() > 0) {
            this.parseFirmware(input);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\r\n" + this.major + "." + this.minor + "." + this.build;
    }

    public void parseFirmware(String input) {
        if (input != null && (input = input.trim()).length() == 8) {
            this.major = input.substring(4, 6);
            this.minor = input.substring(6);
            this.build = input.substring(2, 4);
            this.build = this.build + input.substring(0, 2);
            if (this.major.startsWith("0")) {
                this.major = this.major.substring(1);
            }
        }
    }
}

