/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Protocol;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.re.cm.shared.Tools;
import org.jdom.Document;

public class ReadCameraRecordingInfos
extends PacketXML {
    private long searchFromTimestamp = 0L;
    private long searchToTimestamp = 0L;
    private int maxResults = 0;
    private int flags = 0;
    public static final int MAXIMUM_RESULTS_PER_REQ = 256;

    public ReadCameraRecordingInfos() {
        this.command = Command.CMD_RECORDING_INFOS;
        this.type = Type.TYPE_P_OCTET;
        this.num = 1;
        this.protocol = Protocol.TCP;
    }

    public ReadCameraRecordingInfos(long searchFromTimestamp, long searchToTimestamp, int flags, String sessionId) {
        this(searchFromTimestamp, searchToTimestamp, 256, flags, sessionId);
    }

    public ReadCameraRecordingInfos(long searchFromTimestamp, long searchToTimestamp, int maxResults, int flags, String sessionId) {
        this();
        this.searchFromTimestamp = searchFromTimestamp;
        this.searchToTimestamp = searchToTimestamp;
        this.maxResults = maxResults;
        this.flags = flags;
        this.sessionId = sessionId;
        this.payload = this.createPayload();
    }

    private String createPayload() {
        StringBuilder hexPayload = new StringBuilder();
        hexPayload.append(this.convertTimeToBoschTimeHex(this.searchFromTimestamp));
        hexPayload.append(this.convertTimeToBoschTimeHex(this.searchToTimestamp));
        hexPayload.append(this.get8charHex(this.maxResults));
        hexPayload.append(this.get8charHex(this.flags));
        return hexPayload.toString();
    }

    protected String convertTimeToBoschTimeHex(long timeMilis) {
        long millisecondsTill2000 = Tools.getMilliSecondsSinceYear(2000);
        long boschSecondsFrom2000 = (timeMilis - millisecondsTill2000) / 1000L;
        return this.get8charHex(boschSecondsFrom2000);
    }

    protected String get8charHex(long value) {
        String hex = String.format("%08x", value);
        return hex.substring(hex.length() - 8);
    }

    public Document getResult() {
        return this.result;
    }
}

