/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Protocol;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;

public class PacketXML {
    protected Integer num;
    protected String url;
    protected Document result;
    protected Command command;
    protected String payload;
    protected String sessionId;
    protected Type type;
    protected Protocol protocol;
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    public static final byte ERROR_UNKNOWN = -1;
    public static final byte ERROR_INVALID_VERSION = 16;
    public static final byte ERROR_NOT_REGISTERED = 32;
    public static final byte ERROR_INVALID_CLIENTID = 33;
    public static final byte ERROR_INVALID_METHOD = 48;
    public static final byte ERROR_INVALID_CMD = 64;
    public static final byte ERROR_INVALID_ACCESS_TYPE = 80;
    public static final byte ERROR_INVALID_DATA_TYPE = 96;
    public static final byte ERROR_WRITE_ERROR = 112;
    public static final byte ERROR_PACKET_SIZE = -128;
    public static final byte ERROR_READ_NOT_SUPPORTED = -112;
    public static final byte ERROR_INVALID_AUTH_LEVEL = -96;
    public static final byte ERROR_INVALID_SESSION_ID = -80;
    public static final byte ERROR_TRY_LATER = -64;

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.url != null) {
            ret.append("URL: ");
            ret.append(this.url);
            ret.append("\r\n");
        }
        if (this.result != null) {
            ret.append("RESULT: ");
            ret.append(new XMLOutputter().outputString(this.result));
        }
        return ret.toString();
    }

    public String getResultAsString() {
        if (this.result != null) {
            return this.result.getRootElement().getChild("result").getChildText("str");
        }
        return "";
    }

    public String getResultAsUnicodeString() {
        String res = this.getResultAsString();
        if (!res.equals("")) {
            res = res.replace(" ", "").replace("\r", "").replace("\n", "");
            byte[] resAsBytes = Basic.hexStringToByteArray((String)res);
            try {
                return new String(resAsBytes, "Unicode");
            }
            catch (UnsupportedEncodingException ex) {
                return "";
            }
        }
        return "";
    }

    public int getResultAsInt() {
        String resultString;
        if (this.result != null && (resultString = this.result.getRootElement().getChild("result").getChildText("dec")) != null && !resultString.isEmpty()) {
            return Integer.parseInt(resultString.trim());
        }
        return -1;
    }

    public byte[] getResultAsByteArray() throws Exception {
        String res = this.result.getRootElement().getChild("result").getChildText("str");
        if ((res = res.replace(" ", "").replace("\r", "").replace("\n", "")).startsWith("0x")) {
            res = res.substring(2);
        }
        if (res.length() % 2 != 0) {
            throw new Exception("String could not be converted to byte array: " + res);
        }
        return Basic.hexStringToByteArray((String)res);
    }

    public void send(BoschDevice device, Direction direction) throws Exception {
        this.result = null;
        this.url = "/rcp.xml?command=" + this.command.getCommand() + "&type=" + this.type.getType() + "&direction=" + direction.getDirection();
        if (this.protocol != null) {
            this.url = this.url + "&protocol=" + this.protocol.getProtocol();
        }
        if (this.num != null) {
            this.url = this.url + "&num=" + this.num;
        }
        if (this.payload != null && !this.payload.isEmpty()) {
            this.url = this.url + "&payload=" + this.payload;
        }
        if (this.sessionId != null && !this.sessionId.isEmpty()) {
            this.url = this.url + "&sessionid=" + this.sessionId;
        }
        try {
            this.result = device.getHttpResponseAsXml(this.url);
        }
        catch (JDOMException ex) {
            this.logger.error("JDOMException while sending RCP+ Request: " + ex.getMessage());
            this.logger.error("Request URL was: " + this.url);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while sending RCP+ Request: " + ex.getMessage());
            this.logger.error("Request URL was: " + this.url);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error("Exception while sending RCP+ Request: " + ex.getMessage());
            this.logger.error("Request URL was: " + this.url);
        }
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public static boolean containsResolution(List<CameraResolutionType> cameraResolutions, CameraResolutionType cameraResolution) {
        for (CameraResolutionType cr : cameraResolutions) {
            if (cr.getHeight() != cameraResolution.getHeight() || cr.getWidth() != cameraResolution.getWidth()) continue;
            return true;
        }
        return false;
    }

    public static String convertStringToUnicodeString(String input) {
        if (input == null) {
            return "";
        }
        try {
            input = URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
        char[] chars = input.toCharArray();
        StringBuilder title = new StringBuilder("0x");
        for (int i = 0; i < chars.length; ++i) {
            byte[] b = new byte[2];
            b[1] = (byte)chars[i];
            title.append(Basic.byteArrayToHexString((byte[])b));
        }
        title.append("0000");
        return title.toString();
    }

    public String getPayload() {
        return this.payload;
    }
}

