/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BoschResolution;
import de.seetec.v5.shared.Basic;
import java.util.HashMap;
import java.util.Map;

public class OperationMode {
    private int numberOfStreams;
    public Map<Integer, BoschResolution> resolutions = new HashMap<Integer, BoschResolution>();

    public BoschResolution getResolution(int streamNumber) {
        return this.resolutions.get(streamNumber);
    }

    public int getNumberOfStreams() {
        return this.numberOfStreams;
    }

    public OperationMode(byte[] input, int operationModeType) {
        if (operationModeType == 2 || operationModeType == 0) {
            if (input.length > 4) {
                byte[] numberOfStreamData = new byte[4];
                System.arraycopy(input, 0, numberOfStreamData, 0, 4);
                this.numberOfStreams = (int)Basic.byteArrayToInt8((byte[])numberOfStreamData);
                int pointer = 4;
                for (int i = 0; i < this.numberOfStreams; ++i) {
                    byte[] resolution = new byte[4];
                    System.arraycopy(input, pointer, resolution, 0, resolution.length);
                    int resolutionNumberStream = (int)Basic.byteArrayToInt8((byte[])resolution);
                    this.resolutions.put(i, BoschResolution.getByNumber(resolutionNumberStream));
                    pointer += 4;
                }
            }
        } else if (input.length == 8) {
            byte[] resolution = new byte[4];
            System.arraycopy(input, 1, resolution, 1, 3);
            int resolutionNumberStream = (int)Basic.byteArrayToInt8((byte[])resolution);
            this.resolutions.put(1, BoschResolution.getByNumber(resolutionNumberStream));
            resolution = new byte[4];
            System.arraycopy(input, 5, resolution, 1, 3);
            resolutionNumberStream = (int)Basic.byteArrayToInt8((byte[])resolution);
            this.resolutions.put(2, BoschResolution.getByNumber(resolutionNumberStream));
        }
    }
}

