/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;

public class H264EncoderConfigXML
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpXml.H264EncoderConfigXML";
    private int profileStream1 = -1;
    private int profileStream2 = -1;
    private int mode;

    public int getProfileStream1() {
        return this.profileStream1;
    }

    public int getProfileStream2() {
        return this.profileStream2;
    }

    public int getMode() {
        return this.mode;
    }

    public void setProfileStream1(int profileStream1) {
        this.profileStream1 = profileStream1;
    }

    public void setProfileStream2(int profileStream2) {
        this.profileStream2 = profileStream2;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public H264EncoderConfigXML() {
        this.command = Command.CMD_H264_ENCODER_CONFIG;
        this.type = Type.TYPE_P_OCTET;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            if (this.profileStream1 == -1 || this.profileStream2 == -1) {
                throw new SeeTecException(-20037, "Profile Number not valid for " + this);
            }
            this.payload = "0x" + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)0)) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.profileStream1)) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.profileStream2));
        }
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length >= 12) {
            this.mode = (int)Basic.byteArrayToInt8((byte[])data, (int)0, (int)4);
            this.profileStream1 = (int)Basic.byteArrayToInt8((byte[])data, (int)4, (int)4);
            this.profileStream2 = (int)Basic.byteArrayToInt8((byte[])data, (int)8, (int)4);
        }
    }
}

