/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;

public class H264EncBaseOperationModeXML
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpXml.H264EncBaseOperationModeXML";
    private int resolutionStream1 = -1;
    private int resolutionStream2 = -1;
    private boolean inverted = false;

    public int getResolutionStream1() {
        return this.resolutionStream1;
    }

    public int getResolutionStream2() {
        return this.resolutionStream2;
    }

    public void setResolutionStream1(int resolutionStream1) {
        this.resolutionStream1 = resolutionStream1;
    }

    public void setResolutionStream2(int resolutionStream2) {
        this.resolutionStream2 = resolutionStream2;
    }

    public H264EncBaseOperationModeXML() {
        this.command = Command.CMD_H264_ENC_BASE_OPERATION_MODE;
        this.type = Type.TYPE_P_OCTET;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            if (this.resolutionStream1 == -1 || this.resolutionStream2 == -1) {
                throw new SeeTecException(-20037, "Invalid resolution data for " + this);
            }
            this.payload = this.inverted ? "0x" + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)(0x1000000 + this.resolutionStream1))) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)(0x1000000 + this.resolutionStream2))) : "0x" + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.resolutionStream1)) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.resolutionStream2));
        }
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length >= 8) {
            byte[] resolution = new byte[4];
            System.arraycopy(data, 1, resolution, 1, 3);
            this.resolutionStream1 = (int)Basic.byteArrayToInt8((byte[])resolution);
            resolution = new byte[4];
            System.arraycopy(data, 5, resolution, 1, 3);
            this.resolutionStream2 = (int)Basic.byteArrayToInt8((byte[])resolution);
        }
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public String toString() {
        return super.toString() + "\r\nResolution Stream 1: " + this.resolutionStream1 + ", Stream 2: " + this.resolutionStream2;
    }
}

