/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.shared.Resolution;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfEncProfileResolutionOptionsXML
extends PacketXML {
    Map<Integer, List<Resolution>> resolutionLists = new HashMap<Integer, List<Resolution>>();

    public ConfEncProfileResolutionOptionsXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CONF_ENC_PROFILE_RESOLUTION_OPTIONS;
    }

    public void setVideoSource(int videoSource) {
        this.num = videoSource;
    }

    public List<Resolution> getResolutionList(int streamNumber) {
        return this.resolutionLists.get(streamNumber);
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length > 0) {
            this.fillData(data);
        }
    }

    public void fillData(byte[] inputData) {
        for (int offset = 0; offset < inputData.length; offset += 8) {
            byte[] lengthData = new byte[2];
            System.arraycopy(inputData, offset, lengthData, 0, 2);
            byte[] tagData = new byte[2];
            System.arraycopy(inputData, offset += 2, tagData, 0, 2);
            int tag = Basic.byteArrayToInt4((byte[])tagData);
            offset += 2;
            if (tag == 2) {
                byte stream = inputData[offset];
                byte[] resolutionWidthData = new byte[4];
                System.arraycopy(inputData, offset += 8, resolutionWidthData, 0, 4);
                int resolutionWidth = Basic.byteArrayToInt4((byte[])resolutionWidthData);
                byte[] resolutionHeightData = new byte[4];
                System.arraycopy(inputData, offset += 4, resolutionHeightData, 0, 4);
                int resolutionHeight = Basic.byteArrayToInt4((byte[])resolutionHeightData);
                Resolution resolution = new Resolution(0, resolutionWidth, resolutionHeight, resolutionWidth + "x" + resolutionHeight);
                if (this.resolutionLists.get(stream) == null) {
                    ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
                    resolutions.add(resolution);
                    this.resolutionLists.put(Integer.valueOf(stream), resolutions);
                    continue;
                }
                this.resolutionLists.get(stream).add(resolution);
                continue;
            }
            return;
        }
    }
}

