/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;

public class ConfEncProfileParamsXML
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfEncProfileParamsXML";
    private int basefps;
    private int width;
    private int height;
    private int quality;
    private int fps;

    public ConfEncProfileParamsXML() {
        this.command = Command.CONF_ENC_PROFILE_PARAMS;
        this.type = Type.TYPE_P_OCTET;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            this.setPayload("0x" + this.getResolutionString(this.width, this.height) + this.getQualityString(this.quality) + this.getSkipRatio(this.fps, this.basefps));
        }
        super.send(device, direction);
    }

    public void setBasefps(int basefps) {
        this.basefps = basefps;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public String getResolutionString(int width, int height) {
        String widthAsHex = Integer.toHexString(width);
        while (widthAsHex.length() < 4) {
            widthAsHex = "0" + widthAsHex;
        }
        String heightAsHex = Integer.toHexString(height);
        while (heightAsHex.length() < 4) {
            heightAsHex = "0" + heightAsHex;
        }
        return "00080608" + widthAsHex + heightAsHex;
    }

    public String getQualityString(int quality) {
        int qualityValue = quality / 20 + 1;
        String qualityString = Integer.toHexString(qualityValue);
        if (qualityString.length() == 1) {
            qualityString = "0" + qualityString;
        }
        return "000c0c37" + qualityString + "00000000000000";
    }

    public String getSkipRatio(int fps, int maxFps) {
        int skip = maxFps / fps;
        String skipValue = Integer.toHexString(skip);
        while (skipValue.length() < 8) {
            skipValue = "0" + skipValue;
        }
        return "00080606" + skipValue;
    }
}

