/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CoderVideoOperationModeOptions
extends PacketXML {
    List<Codec> codecList = new ArrayList<Codec>();

    public CoderVideoOperationModeOptions() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_CONF_CODER_VIDEO_OPERATION_MODE_OPTIONS;
    }

    public void setStreamNumber(int streamNumber) {
        this.num = streamNumber;
    }

    public List<Codec> getCodecList() {
        return this.codecList;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length > 0) {
            this.fillData(data);
        }
    }

    public void fillData(byte[] inputData) {
        int offset = 0;
        while (offset + 4 <= inputData.length) {
            byte[] codecData = new byte[4];
            System.arraycopy(inputData, offset, codecData, 0, 4);
            byte[] h265WithoutBFrames = new byte[]{0, 1, 0, 3};
            if (Arrays.equals(codecData, h265WithoutBFrames)) {
                this.codecList.add(Codec.H265);
            } else {
                int codecValue = Basic.byteArrayToInt4((byte[])codecData);
                switch (codecValue) {
                    case 0: {
                        this.codecList.add(Codec.MJPEG);
                        break;
                    }
                    case 1: {
                        this.codecList.add(Codec.H263);
                        break;
                    }
                    case 2: {
                        this.codecList.add(Codec.H264);
                        break;
                    }
                    case 3: {
                        this.codecList.add(Codec.H265);
                        break;
                    }
                }
            }
            offset += 4;
        }
    }
}

