/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.ResolutionMappingSD_JPG;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.List;

public class CapabilityListXML
extends PacketXML {
    private final List<Codec> audioCodecList = new ArrayList<Codec>();
    private final List<ResolutionMappingSD_JPG> resolutionList = new ArrayList<ResolutionMappingSD_JPG>();
    private int numberOfInputs = 0;
    private int numberOfOutputs = 0;
    private int numberOfRS232 = 0;
    private int numberOfRS485 = 0;
    private int numberOfRS422 = 0;
    private boolean supportsAudioOut = false;
    private boolean isH264Supported = false;
    private boolean isH265Supported;

    public CapabilityListXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_CAPABILITY_LIST;
    }

    public boolean isH264Supported() {
        return this.isH264Supported;
    }

    public boolean isH265Supported() {
        return this.isH265Supported;
    }

    public List<ResolutionMappingSD_JPG> getResolutionList() {
        return this.resolutionList;
    }

    public List<Codec> getAudioCodecList() {
        return this.audioCodecList;
    }

    public int getNumberOfInputs() {
        return this.numberOfInputs;
    }

    public int getNumberOfOutputs() {
        return this.numberOfOutputs;
    }

    public int getNumberOfRS232() {
        return this.numberOfRS232;
    }

    public int getNumberOfRS485() {
        return this.numberOfRS485;
    }

    public int getNumberOfRS422() {
        return this.numberOfRS422;
    }

    public boolean isSupportsAudioOut() {
        return this.supportsAudioOut;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length > 0) {
            this.fillData(data);
        }
    }

    public void fillData(byte[] inputData) {
        int offset = 6;
        int numberOfSections = Basic.byteArrayToInt4((byte[])new byte[]{inputData[4], inputData[5]});
        for (int i = 0; i < numberOfSections; ++i) {
            int codec;
            byte type;
            int j;
            int numberOfElements;
            int lengthOfSection = (int)Basic.byteArrayToInt8((byte[])new byte[]{inputData[offset + 2], inputData[offset + 3]});
            if (inputData[offset] == 0 && inputData[offset + 1] == 1) {
                numberOfElements = Basic.byteArrayToInt4((byte[])new byte[]{inputData[offset + 4], inputData[offset + 5]});
                for (j = 0; j < numberOfElements; ++j) {
                    ResolutionMappingSD_JPG resolutionMapping;
                    int resolution;
                    type = inputData[offset + 6 + (j * 10 + 1)];
                    if (type != 1) continue;
                    codec = (int)Basic.byteArrayToInt8((byte[])new byte[]{inputData[offset + 6 + (j * 10 + 4)], inputData[offset + 6 + (j * 10 + 5)]});
                    if ((codec & 4) == 4) {
                        this.isH264Supported = true;
                    }
                    if ((codec & 0x10) == 16) {
                        this.isH265Supported = true;
                    }
                    if (((resolution = (int)Basic.byteArrayToInt8((byte[])new byte[]{inputData[offset + 6 + (j * 10 + 8)], inputData[offset + 6 + (j * 10 + 9)]})) & 1) == 1 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(176, 144))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 2) == 2 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(352, 288))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 4) == 4 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(704, 288))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 8) == 8 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(704, 576))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 0x10) == 16 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(0, 0))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 0x20) == 32 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(320, 240))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 0x40) == 64 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(640, 480))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 0x80) == 128 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(1280, 720))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 0x100) == 256 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(1920, 1080))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 0x200) == 512 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(256, 144))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 0x400) == 1024 && !this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(512, 288))) {
                        this.resolutionList.add(resolutionMapping);
                    }
                    if ((resolution & 0x800) != 2048 || this.containsResolutionMapping(this.resolutionList, resolutionMapping = ResolutionMappingSD_JPG.valueOf(768, 432))) continue;
                    this.resolutionList.add(resolutionMapping);
                }
            } else if (inputData[offset] == 0 && inputData[offset + 1] == 2) {
                numberOfElements = Basic.byteArrayToInt4((byte[])new byte[]{inputData[offset + 4], inputData[offset + 5]});
                for (j = 0; j < numberOfElements; ++j) {
                    type = inputData[offset + 6 + (j * 6 + 1)];
                    if (type == 1) {
                        codec = inputData[offset + 6 + (j * 6 + 5)];
                        if ((codec & 0xF) != 2) continue;
                        this.audioCodecList.add(Codec.G711U);
                        continue;
                    }
                    if (type != 2) continue;
                    this.supportsAudioOut = true;
                }
            } else if (inputData[offset] == 0 && inputData[offset + 1] == 4) {
                numberOfElements = Basic.byteArrayToInt4((byte[])new byte[]{inputData[offset + 4], inputData[offset + 5]});
                for (j = 0; j < numberOfElements; ++j) {
                    type = inputData[offset + 6 + (j * 4 + 1)];
                    if (type == 1) {
                        ++this.numberOfInputs;
                        continue;
                    }
                    if (type != 2) continue;
                    ++this.numberOfOutputs;
                }
            } else if (inputData[offset] == 0 && inputData[offset + 1] == 3) {
                numberOfElements = Basic.byteArrayToInt4((byte[])new byte[]{inputData[offset + 4], inputData[offset + 5]});
                for (j = 0; j < numberOfElements; ++j) {
                    type = inputData[offset + 6 + (j * 4 + 1)];
                    if (type == 1) {
                        ++this.numberOfRS232;
                        continue;
                    }
                    if (type == 2) {
                        ++this.numberOfRS485;
                        continue;
                    }
                    if (type != 3) continue;
                    ++this.numberOfRS422;
                }
            }
            offset += lengthOfSection;
        }
    }

    private boolean containsResolutionMapping(List<ResolutionMappingSD_JPG> resolutionList, ResolutionMappingSD_JPG resolutionMapping) {
        for (ResolutionMappingSD_JPG res : resolutionList) {
            if (res.getWidth() != resolutionMapping.getWidth() || res.getHeight() != resolutionMapping.getHeight()) continue;
            return true;
        }
        return false;
    }
}

