/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmFlag;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmSource;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmType;
import de.seetec.v5.shared.Basic;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class AlarmEntry {
    private final int entryID;
    private final int entryLength;
    private final AlarmSource alarmSource;
    private final AlarmType alarmType;
    private final String alarmName;
    private final List<AlarmFlag> flags = new ArrayList<AlarmFlag>();

    public int getEntryID() {
        return this.entryID;
    }

    public int getEntryLength() {
        return this.entryLength;
    }

    public AlarmSource getAlarmSource() {
        return this.alarmSource;
    }

    public AlarmType getAlarmType() {
        return this.alarmType;
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    public AlarmEntry(byte[] alarmData, int offset) {
        this.entryID = (int)Basic.byteArrayToInt8((byte[])alarmData, (int)offset, (int)2);
        this.entryLength = (int)Basic.byteArrayToInt8((byte[])alarmData, (int)(offset + 2), (int)2);
        if ((alarmData[offset + 4] & AlarmFlag.STATE_SET.getAlarmFlagNumber()) == AlarmFlag.STATE_SET.getAlarmFlagNumber()) {
            this.flags.add(AlarmFlag.STATE_SET);
        }
        if ((alarmData[offset + 4] & AlarmFlag.STATE.getAlarmFlagNumber()) == AlarmFlag.STATE.getAlarmFlagNumber()) {
            this.flags.add(AlarmFlag.STATE);
        }
        if ((alarmData[offset + 4] & AlarmFlag.DELETE.getAlarmFlagNumber()) == AlarmFlag.DELETE.getAlarmFlagNumber()) {
            this.flags.add(AlarmFlag.DELETE);
        }
        if ((alarmData[offset + 4] & AlarmFlag.ADD.getAlarmFlagNumber()) == AlarmFlag.ADD.getAlarmFlagNumber()) {
            this.flags.add(AlarmFlag.ADD);
        }
        this.alarmSource = AlarmSource.valueOf(alarmData[offset + 6]);
        this.alarmType = AlarmType.valueOf(alarmData[offset + 7]);
        this.alarmName = new String(alarmData, offset + 8, this.entryLength - 8, Charset.forName("UNICODE"));
    }

    public boolean containsFlag(AlarmFlag alarmFlag) {
        for (AlarmFlag flag : this.flags) {
            if (flag != alarmFlag) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnyFlag() {
        return this.flags != null && !this.flags.isEmpty();
    }

    public boolean isDeviceAlarm() {
        return this.getAlarmSource() != null && this.getAlarmSource().getAlarmSourceNumber() <= 5;
    }
}

