/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VariantIDDescription;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VariantIDOptionsRsp
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP VariantIDOptions";
    private List<VariantIDDescription> variants = new ArrayList<VariantIDDescription>();

    public VariantIDOptionsRsp() {
        this.setCommand(CMD_VARIANT_ID_OPTIONS);
        this.setDataType((byte)12);
    }

    public List<VariantIDDescription> getVariants() {
        return this.variants;
    }

    public VariantIDDescription getVariant(long ID) {
        for (VariantIDDescription variant : this.variants) {
            if (variant.getVariantID() != ID) continue;
            return variant;
        }
        return null;
    }

    public VariantIDDescription getVariant(String desc) {
        if (desc == null) {
            return null;
        }
        for (VariantIDDescription variant : this.variants) {
            if (!variant.getVariantIDDescription().equals(desc)) continue;
            return variant;
        }
        return null;
    }

    @Override
    public void deserializeBody(byte[] data) {
        if (data != null && data.length > 0) {
            int offset = 4;
            int numberOfSections = data[0];
            for (int i = 0; i < numberOfSections; ++i) {
                long variantID = Basic.byteArrayToInt4((byte[])new byte[]{data[offset], data[offset + 1], data[offset + 2], data[offset + 3]});
                String variantIDDescription = new String(Arrays.copyOfRange(data, offset + 4, offset + 65)).trim();
                this.variants.add(new VariantIDDescription(variantID, variantIDDescription));
                offset += 64;
            }
        }
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        return "n/a";
    }
}

