/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.BoschCameraControl;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TransparentData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransparentDataQueryQueue {
    private final BoschCameraControl cameraControl;
    private final List<TransparentData> pendingMsgs;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private TransparentData currentMsg;
    private boolean gotAccessGranted = false;
    private boolean gotDataMsg = false;

    public TransparentDataQueryQueue(BoschCameraControl cameraControl) {
        this.cameraControl = cameraControl;
        this.pendingMsgs = Collections.synchronizedList(new ArrayList());
    }

    public void queueQuery(TransparentData query) {
        if (query == null) {
            return;
        }
        this.pendingMsgs.add(query);
        if (this.currentMsg == null) {
            this.popNewCurrentMsg();
        }
    }

    public void gotResponse(TransparentData response) {
        if (response.isActionRespone() && this.currentMsg != null && response.getReserved() == this.currentMsg.getReserved()) {
            if (response.accessGranted()) {
                this.gotAccessGranted = true;
            } else {
                this.logger.error("TransparentDataRequest received access denied as a response.");
                this.popNewCurrentMsg();
            }
        } else if (response.isActionMessage() && this.gotAccessGranted) {
            this.gotDataMsg = true;
        }
        if (this.gotAccessGranted && this.gotDataMsg) {
            this.currentMsg = null;
            this.popNewCurrentMsg();
        }
    }

    private void popNewCurrentMsg() {
        if (this.pendingMsgs.isEmpty()) {
            return;
        }
        this.currentMsg = this.pendingMsgs.remove(0);
        this.gotAccessGranted = false;
        this.gotDataMsg = false;
        this.cameraControl.sendRCPDataPacket(this.currentMsg);
    }

    public void clearQueue() {
        this.pendingMsgs.clear();
        this.currentMsg = null;
        this.gotAccessGranted = false;
        this.gotDataMsg = false;
    }

    public boolean isEmpty() {
        return this.pendingMsgs.isEmpty() && this.currentMsg == null;
    }
}

