/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.TransparentData;

public class TransparentDataMsg
extends TransparentData {
    private static final String CLASS_DEBUG_NAME = "RCP TransparentDataMsg";
    public static final byte PELCO_GET_PAN_RETURN_TYPE = 89;
    public static final byte PELCO_GET_TILT_RETURN_TYPE = 91;
    public static final byte PELCO_GET_ZOOM_RETURN_TYPE = 93;
    private byte syncByte;
    private byte addressByte;
    private int command;
    private int msgData;
    private byte checkSumByte;
    private static final int BODY_BYTE_LENGTH = 7;
    private static final int BODY_SYNC_BYTE_INDEX = 0;
    private static final int BODY_ADDRESS_BYTE_INDEX = 1;
    private static final int BODY_CMD_BYTE_INDEX = 2;
    private static final int BODY_DATA_MSB_INDEX = 4;
    private static final int BODY_CHECKSUM_BYTE_INDEX = 6;

    @Override
    public byte[] serializeBody() {
        throw new UnsupportedOperationException("Serialization of the transparent data reuqest response is not supported.");
    }

    @Override
    public void deserializeBody(byte[] data) {
        if (data.length < 7) {
            return;
        }
        this.syncByte = data[0];
        this.addressByte = data[1];
        this.command = TransparentDataMsg.bytesToInt(data, 2, 2);
        this.msgData = TransparentDataMsg.bytesToInt(data, 4, 2);
        this.checkSumByte = data[6];
        byte[] transparentData = new byte[7];
        System.arraycopy(data, 0, transparentData, 0, transparentData.length);
        this.setTransparentData(transparentData);
    }

    public byte getSyncByte() {
        return this.syncByte;
    }

    public String getSyncByteHex() {
        return this.getHexString(this.getSyncByte());
    }

    public byte getAddressByte() {
        return this.addressByte;
    }

    public String getAddressByteHex() {
        return this.getHexString(this.getAddressByte());
    }

    public int getMsgCommand() {
        return this.command;
    }

    public String getMsgCommandHex() {
        return this.getHexString(this.getMsgCommand());
    }

    public int getData() {
        return this.msgData;
    }

    public String getDataHex() {
        return this.getHexString(this.getData());
    }

    public byte getCheckSumByte() {
        return this.checkSumByte;
    }

    public String getCheckSumByteHex() {
        return this.getHexString(this.getCheckSumByte());
    }

    private String getHexString(byte value) {
        return String.format("%02X", value);
    }

    private String getHexString(int value) {
        return String.format("%04X", value);
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME;
    }

    @Override
    protected String getClassDebugInfo() {
        return "Data [ " + (this.getTransparentData() == null ? "null" : TransparentDataMsg.hexString(this.getHeader()) + "| " + TransparentDataMsg.hexString(this.getTransparentData())) + "]";
    }
}

