/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class TransparentData
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP TransparentData";
    private byte options;
    private byte reservedInBody;
    private byte[] transparentData;
    private int leaseTime;

    public TransparentData() {
        this.setCommand(CMD_TRANSPARENT_DATA);
        this.setDataType((byte)12);
        this.setWrite();
        this.setOptions((byte)0);
        this.setReservedInBody((byte)0);
        this.setLeaseTime(0);
    }

    @Override
    public byte[] serializeBody() {
        byte[] body = new byte[4 + this.transparentData.length];
        body[0] = this.options;
        body[1] = this.reservedInBody;
        System.arraycopy(TransparentData.intTo2Bytes(this.leaseTime), 0, body, 2, 2);
        System.arraycopy(this.transparentData, 0, body, 4, this.transparentData.length);
        return body;
    }

    @Override
    public void deserializeBody(byte[] data) {
        if (data.length < 4) {
            return;
        }
        this.options = data[0];
        this.reservedInBody = data[1];
        this.leaseTime = TransparentData.bytesToInt(data, 2, 2);
        this.transparentData = new byte[data.length - 4];
        System.arraycopy(data, 4, this.transparentData, 0, this.transparentData.length);
    }

    public byte getOptions() {
        return this.options;
    }

    public void setOptions(byte b) {
        this.options = b;
    }

    public boolean accessGranted() {
        return this.options == 1;
    }

    public boolean accessDenied() {
        return this.options == 0;
    }

    public byte getReservedInBody() {
        return this.reservedInBody;
    }

    public void setReservedInBody(byte b) {
        this.reservedInBody = b;
    }

    public int getLeaseTime() {
        return this.leaseTime;
    }

    public void setLeaseTime(int i) {
        this.leaseTime = i;
    }

    public byte[] getTransparentData() {
        return this.transparentData;
    }

    public void setTransparentData(byte[] bytes) {
        this.transparentData = bytes;
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME;
    }

    @Override
    protected String getClassDebugInfo() {
        if (this.isActionRequest()) {
            return "Data [" + (this.getTransparentData() == null ? "null" : TransparentData.hexString(this.getTransparentData())) + "]";
        }
        return "Result : Access " + (this.options == 0 ? "denied" : "granted");
    }
}

