/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.EncoderOperationMode;
import de.seetec.v5.shared.Basic;
import java.util.Arrays;

public class OperationModeCombination {
    private EncoderOperationMode[] encoderOperationMode;
    private byte[] combinationAsByteArray;

    public OperationModeCombination(int numberOfStreams, byte[] possibleCombination) {
        this.combinationAsByteArray = possibleCombination;
        if (numberOfStreams > 0) {
            if (possibleCombination.length % numberOfStreams != 0) {
                return;
            }
            this.encoderOperationMode = new EncoderOperationMode[numberOfStreams];
            int lengthOfField = possibleCombination.length / numberOfStreams;
            for (int i = 0; i < numberOfStreams; ++i) {
                int start = i * lengthOfField;
                int end = start + lengthOfField;
                byte[] onePartOfCombinationAsArray = Arrays.copyOfRange(possibleCombination, start, end);
                int onePartOfCombination = Basic.byteArrayToInt4((byte[])onePartOfCombinationAsArray);
                this.encoderOperationMode[i] = EncoderOperationMode.valueOf(onePartOfCombination);
            }
        }
    }

    public EncoderOperationMode[] getCombination() {
        return this.encoderOperationMode;
    }

    public byte[] getCombinationAsByteArray() {
        return this.combinationAsByteArray;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Combination:\r\n");
        if (this.encoderOperationMode != null) {
            for (int i = 0; i < this.encoderOperationMode.length; ++i) {
                result.append(String.format("  Stream %s: (%s) %s", new Object[]{i + 1, this.encoderOperationMode[i].getOperationTag(), this.encoderOperationMode[i]}));
                result.append("\r\n");
            }
        } else {
            result.append("  n/a");
            result.append("\r\n");
        }
        return result.toString();
    }
}

