/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class MediaDescriptor {
    public static final byte MEDIA_VIDEO = 1;
    public static final byte MEDIA_AUDIO = 2;
    public static final byte MEDIA_DATA = 3;
    public static final byte METHOD_GET = 0;
    public static final byte METHOD_PUT = 1;
    public static final byte MEP_RTPOVERUDP = 1;
    public static final byte MEP_RTPOVERTCP = 4;
    public static final byte STATUS_NOTAVAILABLE = 0;
    public static final byte STATUS_ACCESSGRANTED = 1;
    public static final byte STATUS_ACCESSDENIED = 2;
    public static final byte STATUS_IDIVALIDORTIMEOUT = 3;
    public static final byte STATUS_BADCODINGPARAMETERS = 4;
    public static final byte STATUS_SUPPLIEDBYANOTHERMD = 5;
    static final byte[] CODING_DONTCARE = new byte[]{-1, -1};
    public static final byte[] CODING_G711 = new byte[]{0, 1};
    static final byte[] CODING_H263 = new byte[]{0, 2};
    public static final byte[] CODING_MPEG4_ELEM = new byte[]{0, 4};
    static final byte[] CODING_MPEG2_VIDEO = new byte[]{0, 8};
    public static final byte[] CODING_H264 = new byte[]{0, 64};
    public static final byte[] CODING_JPEG = new byte[]{0, -128};
    static final byte[] CODING_RECORDED = new byte[]{64, 0};
    static final byte[] CODING_MPEG2_PROGRAM = new byte[]{-128, 0};
    static final byte[] RESOLUTION_DONTCARE = new byte[]{-1, -1};
    static final byte[] RESOLUTION_QCIF = new byte[]{0, 1};
    static final byte[] RESOLUTION_CIF = new byte[]{0, 2};
    static final byte[] RESOLUTION_2CIF = new byte[]{0, 4};
    static final byte[] RESOLUTION_4CIF = new byte[]{0, 8};
    static final byte[] ADDRESS_READ_INCOMING = new byte[]{0, 0, 0, 0};
    static final byte[] ADDRESS_USE_CONFIGURED = new byte[]{-32, 0, 0, 0};
    private static final String CLASS_DEBUG_NAME = "MediaDescriptor";
    private byte[] data = new byte[32];

    public static MediaDescriptor createMpeg4VideoMediaDescriptor() {
        MediaDescriptor md = new MediaDescriptor();
        md.setMethodGet();
        md.setMediaVideo();
        md.setMEP((byte)1);
        md.setMTAAddress(ADDRESS_READ_INCOMING);
        md.setLine((byte)1);
        md.setMCTAAddress(ADDRESS_READ_INCOMING);
        md.setCoding(CODING_MPEG4_ELEM);
        md.setResolution(RESOLUTION_DONTCARE);
        md.setBandwidth(1);
        return md;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] bytes) {
        System.arraycopy(bytes, 0, this.data, 0, this.data.length);
    }

    public void setMethodPut() {
        this.data[0] = 1;
    }

    public boolean isMethodPut() {
        return this.data[0] == 1;
    }

    public void setMethodGet() {
        this.data[0] = 0;
    }

    public boolean isMethodGet() {
        return this.data[0] == 0;
    }

    public void setMediaVideo() {
        this.data[1] = 1;
    }

    public boolean isMediaVideo() {
        return this.data[1] == 1;
    }

    public void setMediaAudio() {
        this.data[1] = 2;
    }

    public boolean isMediaAudio() {
        return this.data[1] == 2;
    }

    public void setMediaData() {
        this.data[1] = 3;
    }

    public boolean isMediaData() {
        return this.data[1] == 3;
    }

    public void setStatus(byte b) {
        this.data[2] = b;
    }

    public byte getStatus() {
        return this.data[2];
    }

    public boolean isStatusError() {
        return this.data[2] != 1 && this.data[2] != 5;
    }

    public byte getMEP() {
        return this.data[8];
    }

    public void setMEP(byte b) {
        this.data[8] = b;
    }

    public byte getFlags() {
        return this.data[9];
    }

    public void setFlags(byte b) {
        this.data[9] = b;
    }

    public int getMTAPort() {
        return Packet.bytesToInt(this.data, 10, 2);
    }

    public void setMTAPort(int port) {
        byte[] bytes = Packet.intTo2Bytes(port);
        this.data[10] = bytes[0];
        this.data[11] = bytes[1];
    }

    public byte[] getMTAddress() {
        return new byte[]{this.data[12], this.data[13], this.data[14], this.data[15]};
    }

    public void setMTAAddress(byte[] bytes) {
        this.data[12] = bytes[0];
        this.data[13] = bytes[1];
        this.data[14] = bytes[2];
        this.data[15] = bytes[3];
    }

    public byte getCoder() {
        return this.data[16];
    }

    public void setCoder(byte b) {
        this.data[16] = b;
    }

    public byte getLine() {
        return this.data[17];
    }

    public void setLine(byte b) {
        this.data[17] = b;
    }

    public int getMCTAPort() {
        return Packet.bytesToInt(this.data, 18, 2);
    }

    public void setMCTAPort(int port) {
        byte[] bytes = Packet.intTo2Bytes(port);
        this.data[18] = bytes[0];
        this.data[19] = bytes[1];
    }

    public byte[] getMCTAddress() {
        return new byte[]{this.data[20], this.data[21], this.data[22], this.data[23]};
    }

    public void setMCTAAddress(byte[] bytes) {
        this.data[20] = bytes[0];
        this.data[21] = bytes[1];
        this.data[22] = bytes[2];
        this.data[23] = bytes[3];
    }

    public byte[] getCoding() {
        return new byte[]{this.data[24], this.data[25]};
    }

    public void setCoding(byte[] bytes) {
        this.data[24] = bytes[0];
        this.data[25] = bytes[1];
    }

    public byte[] getResolution() {
        return new byte[]{this.data[26], this.data[27]};
    }

    public void setResolution(byte[] bytes) {
        this.data[26] = bytes[0];
        this.data[27] = bytes[1];
    }

    public byte getLinkedCoder() {
        return this.data[28];
    }

    public void setLinkedCoder(byte linkedCoder) {
        this.data[28] = linkedCoder;
    }

    public byte getLinkedLine() {
        return this.data[29];
    }

    public void setLinkedLine(byte linkedLine) {
        this.data[29] = linkedLine;
    }

    public int getBandwidth() {
        return Packet.bytesToInt(this.data, 30, 2);
    }

    public void setBandwidth(int bw) {
        byte[] bytes = Packet.intTo2Bytes(bw);
        this.data[30] = bytes[0];
        this.data[31] = bytes[1];
    }

    public String toString() {
        return CLASS_DEBUG_NAME;
    }

    public String toStringReq() {
        String method = this.isMethodGet() ? "get" : "put";
        String mep = this.getMEP() == 4 ? "Tcp" : "Udp";
        mep = mep + " " + this.getMTAPort();
        return "[ " + mep + ", " + method + this.toString_Coding() + " ]";
    }

    public String toStringRsp() {
        String method = this.isMethodGet() ? "get" : "put";
        String mep = this.getMEP() == 4 ? "Tcp" : "Udp";
        mep = mep + " " + this.getMTAPort();
        String status = this.toStringStatus();
        return "[ " + mep + ", " + method + this.toString_Coding() + " " + status + " ], ";
    }

    public String toStringStatus() {
        String str;
        byte status = this.getStatus();
        switch (status) {
            case 0: {
                str = "Interface not available";
                break;
            }
            case 1: {
                str = "Access granted";
                break;
            }
            case 2: {
                str = "Access denied";
                break;
            }
            case 3: {
                str = "SessionID invalid or timed out";
                break;
            }
            case 4: {
                str = "coding parameters incompatible";
                break;
            }
            case 5: {
                str = "data supplied by another descriptor";
                break;
            }
            default: {
                str = "Unknown message";
            }
        }
        return str + "[" + Packet.hexString(status) + "]";
    }

    public String toString_Coding() {
        String codingString = "";
        byte[] coding = this.getCoding();
        if (coding[0] == CODING_DONTCARE[0] && coding[1] == CODING_DONTCARE[1]) {
            codingString = "coding don't care";
        } else {
            if ((coding[0] & CODING_G711[0]) != 0 || (coding[1] & CODING_G711[1]) != 0) {
                if (!codingString.isEmpty()) {
                    codingString = codingString + "|";
                }
                codingString = codingString + "G711";
            }
            if ((coding[0] & CODING_H263[0]) != 0 || (coding[1] & CODING_H263[1]) != 0) {
                if (!codingString.isEmpty()) {
                    codingString = codingString + "|";
                }
                codingString = codingString + "H263";
            }
            if ((coding[0] & CODING_MPEG4_ELEM[0]) != 0 || (coding[1] & CODING_MPEG4_ELEM[1]) != 0) {
                if (!codingString.isEmpty()) {
                    codingString = codingString + "|";
                }
                codingString = codingString + "Mpeg4_Elem";
            }
            if ((coding[0] & CODING_MPEG2_VIDEO[0]) != 0 || (coding[1] & CODING_MPEG2_VIDEO[1]) != 0) {
                if (!codingString.isEmpty()) {
                    codingString = codingString + "|";
                }
                codingString = codingString + "Mpeg2_Video";
            }
            if ((coding[0] & CODING_RECORDED[0]) != 0 || (coding[1] & CODING_RECORDED[1]) != 0) {
                if (!codingString.isEmpty()) {
                    codingString = codingString + "|";
                }
                codingString = codingString + "Recorded";
            }
            if ((coding[0] & CODING_MPEG2_PROGRAM[0]) != 0 || (coding[1] & CODING_MPEG2_PROGRAM[1]) != 0) {
                if (!codingString.isEmpty()) {
                    codingString = codingString + "|";
                }
                codingString = codingString + "Mpeg2_Program";
            }
        }
        if (this.isMediaVideo()) {
            return "Video, [" + codingString + "]";
        }
        if (this.isMediaAudio()) {
            return "Audio, [" + codingString + "]";
        }
        return "Data";
    }
}

