/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.mpeg.ResolutionMapping;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public final class JpegStreamSetup
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP JpegStreamSetup";
    private int resolutionValue = -1;
    private int fpsValue = -1;
    private int qualityValue = -1;

    public JpegStreamSetup() {
        this.setCommand(Packet.CMD_CONF_JPEG_STREAM_SETUP);
        this.setDataType((byte)12);
    }

    public final void setResolution(int resolution) {
        this.resolutionValue = resolution;
    }

    public final void setFPS(int fps) {
        this.fpsValue = fps;
    }

    public final void setQuality(int quality) {
        this.qualityValue = quality;
    }

    public final int getResolution() {
        return this.resolutionValue;
    }

    public final int getFPS() {
        return this.fpsValue;
    }

    public final int getQuality() {
        return this.qualityValue;
    }

    @Override
    protected final void deserializeBody(byte[] data) {
        if (data != null && data.length > 0) {
            byte[] resolutionData = new byte[4];
            byte[] fpsData = new byte[4];
            byte[] qualityData = new byte[4];
            System.arraycopy(data, 0, resolutionData, 0, 4);
            System.arraycopy(data, 4, fpsData, 0, 4);
            System.arraycopy(data, 8, qualityData, 0, 4);
            this.resolutionValue = Packet.bytesToInt(resolutionData);
            this.fpsValue = Packet.bytesToInt(fpsData);
            this.qualityValue = Packet.bytesToInt(qualityData);
        }
    }

    @Override
    public final byte[] serializeBody() {
        if (this.isActionRequest()) {
            byte[] data = new byte[12];
            System.arraycopy(Packet.intTo4Bytes(this.resolutionValue), 0, data, 0, 4);
            System.arraycopy(Packet.intTo4Bytes(this.fpsValue), 0, data, 4, 4);
            System.arraycopy(Packet.intTo4Bytes(this.qualityValue), 0, data, 8, 4);
            return data;
        }
        return new byte[0];
    }

    @Override
    protected final String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected final String getClassDebugInfo() {
        if (this.isActionRequest() ^ this.getWrite()) {
            return "Encoder [ " + this.toStringNumdesc() + " ]";
        }
        return "Encoder [ " + this.toStringNumdesc() + " ], ResolutionValue [ " + (Object)((Object)ResolutionMapping.valueOf(this.resolutionValue)) + " ], FPSValue [ " + this.getFPS() + " ], QualityValue [ " + this.getQuality() + " ]";
    }
}

