/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.EncoderOperationMode;
import de.seetec.v5.re.cm.device.video.bosch.rcp.OperationModeCombination;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.Arrays;

public class H264EncBaseOperationMode
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP H264EncBaseOperationMode";
    private byte[] payload = null;
    private int stream = 0;
    private int value = 0;

    public H264EncBaseOperationMode() {
        this.setCommand(CMD_H264_ENC_BASE_OPERATION_MODE);
        this.setDataType((byte)12);
        this.setAction((byte)0);
        this.setWrite();
    }

    @Override
    protected void deserializeBody(byte[] data) {
        this.payload = new byte[this.getPayloadLength()];
        System.arraycopy(data, 0, this.payload, 0, this.payload.length);
    }

    @Override
    public byte[] serializeBody() {
        return this.getWrite() ? this.payload : new byte[]{};
    }

    public void setBaseOperationMode(ArrayList<OperationModeCombination> caps, byte[] currentValue, int stream, EncoderOperationMode requestedEncoderOperationMode) {
        this.stream = stream;
        this.value = requestedEncoderOperationMode.getOperationTag();
        byte[] DWORD = Basic.int4ToByteArray((int)this.value);
        this.payload = currentValue;
        System.arraycopy(DWORD, 0, this.payload, (stream - 1) * 4, 4);
        if (caps != null && caps.size() > 0) {
            boolean settingAllowed = false;
            for (OperationModeCombination opMode : caps) {
                if (!Arrays.equals(this.payload, opMode.getCombinationAsByteArray())) continue;
                settingAllowed = true;
                break;
            }
            if (!settingAllowed) {
                this.logger.warn("Requested combination not possible on this device: " + Basic.byteArrayToHexString((byte[])this.payload));
                int startIndex = (stream - 1) * 4;
                for (OperationModeCombination opMode : caps) {
                    byte[] partToCompare = Arrays.copyOfRange(opMode.getCombinationAsByteArray(), startIndex, startIndex + 4);
                    if (!Arrays.equals(partToCompare, DWORD)) continue;
                    this.payload = opMode.getCombinationAsByteArray();
                    this.logger.info("Following combination will be used instead: " + Basic.byteArrayToHexString((byte[])this.payload));
                    break;
                }
            }
        }
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME;
    }

    @Override
    protected String getClassDebugInfo() {
        return "Stream: " + this.stream + ", OpCode: " + this.value + ", Line [ " + this.toStringNumdesc() + " ]";
    }
}

