/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class ConfVideoInputFormatEx
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP ConfVideoInputFormatEx";
    private MODE mode = MODE.FIXED;
    private VIDEO_FORMAT videoFormat = VIDEO_FORMAT.NO;

    public ConfVideoInputFormatEx() {
        this.setCommand(CMD_CONF_VIDEO_INPUT_FORMAT_EX);
        this.setDataType((byte)12);
        this.setAction((byte)0);
    }

    public void setMode(MODE mode) {
        this.mode = mode;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setVideoFormat(VIDEO_FORMAT videoFormat) {
        this.videoFormat = videoFormat;
    }

    public VIDEO_FORMAT getVideoFormat() {
        return this.videoFormat;
    }

    @Override
    protected void deserializeBody(byte[] data) {
        if (data != null && data.length > 2) {
            this.mode = MODE.valueOf(data[0]);
            this.videoFormat = VIDEO_FORMAT.valueOf(data[1]);
        }
    }

    @Override
    public byte[] serializeBody() {
        if (this.isActionRequest()) {
            byte[] payload = new byte[20];
            payload[0] = this.mode.getModeValue();
            payload[1] = this.videoFormat.getVideoFormatValue();
            return payload;
        }
        return new byte[0];
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        return "Mode [ " + (Object)((Object)this.mode) + " ], VideoFormat [ " + (Object)((Object)this.videoFormat) + " ]";
    }

    public static enum VIDEO_FORMAT {
        NO(0, "n/a", -1),
        PAL(1, "n/a", -1),
        NTSC(2, "n/a", -1),
        VGA(3, "640x480", 30),
        FORMAT_720P(4, "720P", -1),
        FORMAT_1080P(5, "1080P", -1),
        FORMAT_QVGA(6, "n/a", -1),
        FORMAT_720P25(7, "720P", 25),
        FORMAT_720P30(8, "720P", 30),
        FORMAT_720P50(9, "720P", 50),
        FORMAT_720P60(10, "720P", 60),
        FORMAT_1080P25(11, "1080P", 25),
        FORMAT_1080P30(12, "1080P", 30),
        FORMAT_2592x1944P12(13, "2592x1944", 12),
        FORMAT_1440x1080P25(14, "1440x1080", 25),
        FORMAT_1440x1080P30(15, "1440x1080", 30),
        FORMAT_640x480P25(16, "640x480", 25),
        FORMAT_1280x1024P25(17, "1280x1024", 25),
        FORMAT_1280x1024P30(18, "1280x1024", 30),
        FORMAT_2704x2032P25(19, "5MP (4:3)", 25),
        FORMAT_2704x2032P30(20, "5MP (4:3)", 30),
        FORMAT_2992x1680P25(21, "5MP (16:9)", 25),
        FORMAT_2992x1680P30(22, "5MP (16:9)", 30),
        FORMAT_3840x2160P15(23, "4K UHD (16:9)", 15),
        FORMAT_3840x2160P25(24, "4K UHD (16:9)", 25),
        FORMAT_3840x2160P30(25, "4K UHD (16:9)", 30),
        FORMAT_4000x3000P15(26, "12MP (4:3)", 15),
        FORMAT_4000x3000P20(27, "12MP (4:3)", 20);

        private byte videoFormat;
        private int maxFrameRate = -1;
        private String maxResolution = null;

        private VIDEO_FORMAT(byte videoFormat, String maxResolution, int maxFrameRate) {
            this.videoFormat = videoFormat;
            this.maxResolution = maxResolution;
            this.maxFrameRate = maxFrameRate;
        }

        public byte getVideoFormatValue() {
            return this.videoFormat;
        }

        public int getMaxFrameRate() {
            return this.maxFrameRate;
        }

        public String getMaxResolution() {
            return this.maxResolution;
        }

        public static VIDEO_FORMAT valueOf(byte givenFormat) {
            VIDEO_FORMAT format = null;
            for (VIDEO_FORMAT t : VIDEO_FORMAT.values()) {
                if (givenFormat != t.getVideoFormatValue()) continue;
                format = t;
                break;
            }
            return format;
        }

        public static VIDEO_FORMAT valueOf(String resolution, int maxFrameRate) {
            VIDEO_FORMAT format = null;
            if (resolution == null || maxFrameRate < 0) {
                return format;
            }
            for (VIDEO_FORMAT t : VIDEO_FORMAT.values()) {
                if (!t.getMaxResolution().equalsIgnoreCase(resolution) || t.getMaxFrameRate() != maxFrameRate) continue;
                format = t;
                break;
            }
            return format;
        }
    }

    public static enum MODE {
        FIXED(0),
        AUTO(1);

        private byte mode;

        private MODE(byte mode) {
            this.mode = mode;
        }

        public byte getModeValue() {
            return this.mode;
        }

        public static MODE valueOf(byte givenMode) {
            MODE mode = null;
            for (MODE t : MODE.values()) {
                if (givenMode != t.getModeValue()) continue;
                mode = t;
                break;
            }
            return mode;
        }
    }
}

