/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class CoderListRsp
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP CoderList";
    byte[] coders = new byte[6];
    byte[] body = null;

    public CoderListRsp() {
        this.setCommand(CMD_CODER_LIST);
        this.setDataType((byte)12);
        this.setAction((byte)1);
        this.setWrite();
    }

    @Override
    public void deserializeBody(byte[] body) {
        this.body = body;
        int encoder = 0;
        int infoBlocks = body.length / 16;
        for (int i = 0; i < infoBlocks; ++i) {
            if (body[i * 16 + 2] != 0 || body[i * 16 + 3] == 16) continue;
            this.coders[encoder] = body[i * 16 + 1];
            ++encoder;
        }
    }

    public byte[] getCoders() {
        return this.coders;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RCP CoderList: Coders [ ").append(this.coders[0]).append(",").append(this.coders[1]).append("]");
        stringBuffer.append("\n\n");
        int infoBlocks = this.body.length / 16;
        for (int i = 0; i < infoBlocks; ++i) {
            int pointer = i * 16;
            stringBuffer.append("CodingNbr: ");
            stringBuffer.append(Integer.toHexString(this.body[pointer])).append(Integer.toHexString(this.body[pointer + 1]));
            stringBuffer.append(" | ");
            stringBuffer.append("Coding Capabilities: ");
            String codingCaps = Integer.toHexString(this.body[pointer + 3]);
            String codingCapsAsString = "";
            if (codingCaps.endsWith("10")) {
                codingCapsAsString = "Meta Data";
            } else if (codingCaps.endsWith("40")) {
                codingCapsAsString = "H.264";
            } else if (codingCaps.endsWith("80")) {
                codingCapsAsString = "Jpeg";
            }
            stringBuffer.append(codingCaps).append(" (").append(codingCapsAsString).append(")");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME;
    }

    @Override
    protected String getClassDebugInfo() {
        return "RCP CoderList: Coders [ " + this.coders[0] + "," + this.coders[1] + "]";
    }
}

